/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.DummyIdentifierPatcher;
import com.intellij.codeInsight.completion.FileCopyPatcher;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenPropertyCompletionContributor
extends CompletionContributor {
    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        int offset;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenPropertyCompletionContributor.beforeCompletion must not be null");
        }
        Project project = context.getProject();
        PsiFile psiFile = context.getFile();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        if (!manager.isMavenizedProject()) {
            return;
        }
        MavenProject projectFile = MavenDomUtil.findContainingProject((PsiElement)psiFile);
        if (projectFile == null) {
            return;
        }
        if (!MavenDomUtil.isMavenFile(psiFile) && !MavenDomUtil.isFiltererResourceFile((PsiElement)psiFile)) {
            return;
        }
        CharSequence text = context.getEditor().getDocument().getCharsSequence();
        if (this.isAfterOpenBrace(text, offset = context.getStartOffset())) {
            context.setFileCopyPatcher((FileCopyPatcher)new DummyIdentifierPatcher("IntellijIdeaRulezzz ".trim() + "}"));
        }
    }

    private boolean isAfterOpenBrace(CharSequence text, int offset) {
        for (int i = offset - 1; i > 0; --i) {
            char c = text.charAt(i);
            if (c == '{' && text.charAt(i - 1) == '$') {
                return true;
            }
            if (Character.isLetterOrDigit(c) || c == '.') continue;
            return false;
        }
        return false;
    }

    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        super.fillCompletionVariants(parameters, result);
    }
}

