/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.MavenGenerateProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.navigator.SelectMavenProjectDialog;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenIcons;

public class GenerateParentAction
extends GenerateDomElementAction {
    public GenerateParentAction() {
        super((GenerateDomElementProvider)new MavenGenerateProvider<MavenDomParent>("Generate Parent", MavenDomParent.class){

            @Override
            protected MavenDomParent doGenerate(final MavenDomProjectModel mavenModel, Editor editor) {
                SelectMavenProjectDialog d = new SelectMavenProjectDialog(editor.getProject(), null);
                d.show();
                if (!d.isOK()) {
                    return null;
                }
                final MavenProject parentProject = d.getResult();
                if (parentProject == null) {
                    return null;
                }
                return (MavenDomParent)new WriteCommandAction<MavenDomParent>(editor.getProject(), this.getDescription(), new PsiFile[0]){

                    protected void run(Result result) throws Throwable {
                        result.setResult((Object)MavenDomUtil.updateMavenParent(mavenModel, parentProject));
                    }
                }.execute().getResultObject();
            }

            @Override
            protected boolean isAvailableForModel(MavenDomProjectModel mavenModel) {
                return !DomUtil.hasXml((DomElement)mavenModel.getMavenParent());
            }
        }, MavenIcons.MAVEN_PROJECT_ICON);
    }

    protected boolean startInWriteAction() {
        return false;
    }
}

