/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.converters.PathReferenceConverter;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.io.File;
import java.util.Set;

public class MavenDomConvertersRegistry {
    protected GenericDomValueConvertersRegistry myConvertersRegistry;
    private Set<String> mySoftConverterTypes = new HashSet();

    public static MavenDomConvertersRegistry getInstance() {
        return (MavenDomConvertersRegistry)ServiceManager.getService(MavenDomConvertersRegistry.class);
    }

    public MavenDomConvertersRegistry() {
        this.myConvertersRegistry = new GenericDomValueConvertersRegistry();
        this.initConverters();
        this.initSoftConverterTypes();
    }

    private void initSoftConverterTypes() {
        this.mySoftConverterTypes.add(File.class.getCanonicalName());
    }

    private void initConverters() {
        this.myConvertersRegistry.registerDefaultConverters();
        this.myConvertersRegistry.registerConverter(PathReferenceConverter.INSTANCE, File.class);
    }

    public GenericDomValueConvertersRegistry getConvertersRegistry() {
        return this.myConvertersRegistry;
    }

    public boolean isSoft(String type) {
        return this.mySoftConverterTypes.contains(type);
    }
}

