/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.model.MavenDomSettingsModel;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.project.MavenParentProjectFileProcessor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenDomProjectProcessorUtils {
    private MavenDomProjectProcessorUtils() {
    }

    @Nullable
    public static XmlTag searchProperty(final @NotNull String propertyName, @NotNull MavenDomProjectModel projectDom, @NotNull Project project) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.searchProperty must not be null");
        }
        if (projectDom == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.searchProperty must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.searchProperty must not be null");
        }
        final XmlTag[] property = new XmlTag[]{null};
        Processor<MavenDomProperties> searchProcessor = new Processor<MavenDomProperties>(){

            public boolean process(MavenDomProperties mavenDomProperties) {
                XmlTag propertiesTag = mavenDomProperties.getXmlTag();
                if (propertiesTag != null) {
                    for (XmlTag each : propertiesTag.getSubTags()) {
                        if (!each.getName().equals(propertyName)) continue;
                        property[0] = each;
                        return true;
                    }
                }
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processProperties(projectDom, searchProcessor, project);
        return property[0];
    }

    @Nullable
    public static Set<XmlTag> collectProperties(@NotNull MavenDomProjectModel projectDom, @NotNull Project project) {
        if (projectDom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.collectProperties must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.collectProperties must not be null");
        }
        HashSet properties = new HashSet();
        Processor<MavenDomProperties> collectProcessor = new Processor<MavenDomProperties>((Set)properties){
            final /* synthetic */ Set val$properties;
            {
                this.val$properties = set;
            }

            public boolean process(MavenDomProperties mavenDomProperties) {
                XmlTag propertiesTag = mavenDomProperties.getXmlTag();
                if (propertiesTag != null) {
                    this.val$properties.addAll(Arrays.asList(propertiesTag.getSubTags()));
                }
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processProperties(projectDom, collectProcessor, project);
        return properties;
    }

    @NotNull
    public static Set<MavenDomDependency> searchDependencyUsages(final @NotNull MavenDomDependency dependency, @NotNull Project project) {
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.searchDependencyUsages must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.searchDependencyUsages must not be null");
        }
        HashSet usages = new HashSet();
        final MavenDomProjectModel model = (MavenDomProjectModel)dependency.getParentOfType(MavenDomProjectModel.class, false);
        if (model != null) {
            final String artifactId = dependency.getArtifactId().getStringValue();
            final String groupId = dependency.getGroupId().getStringValue();
            if (artifactId != null && groupId != null) {
                Processor<MavenDomProjectModel> collectProcessor = new Processor<MavenDomProjectModel>((Set)usages){
                    final /* synthetic */ Set val$usages;
                    {
                        this.val$usages = set;
                    }

                    public boolean process(MavenDomProjectModel mavenDomProjectModel) {
                        if (!model.equals(mavenDomProjectModel)) {
                            for (MavenDomDependency domDependency : mavenDomProjectModel.getDependencies().getDependencies()) {
                                if (domDependency.equals(dependency) || !artifactId.equals(domDependency.getArtifactId().getStringValue()) || !groupId.equals(domDependency.getGroupId().getStringValue())) continue;
                                this.val$usages.add(domDependency);
                            }
                        }
                        return false;
                    }
                };
                MavenDomProjectProcessorUtils.processProjectDependenciesRecursively(model, collectProcessor, project, (Set<MavenDomProjectModel>)new HashSet());
            }
        }
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.searchDependencyUsages must not return null");
        }
        return hashSet;
    }

    private static void processProjectDependenciesRecursively(@Nullable MavenDomProjectModel model, @NotNull Processor<MavenDomProjectModel> processor, @NotNull Project project, @NotNull Set<MavenDomProjectModel> processedModels) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processProjectDependenciesRecursively must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processProjectDependenciesRecursively must not be null");
        }
        if (processedModels == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processProjectDependenciesRecursively must not be null");
        }
        if (model != null && !processedModels.contains(model)) {
            processedModels.add(model);
            if (processor.process((Object)model)) {
                return;
            }
            MavenProject mavenProject = MavenDomUtil.findProject(model);
            if (mavenProject != null) {
                for (MavenProject childProject : MavenProjectsManager.getInstance(project).findInheritors(mavenProject)) {
                    MavenDomProjectModel childProjectModel = MavenDomUtil.getMavenDomProjectModel(project, childProject.getFile());
                    MavenDomProjectProcessorUtils.processProjectDependenciesRecursively(childProjectModel, processor, project, processedModels);
                }
            }
        }
    }

    @NotNull
    public static Set<MavenDomDependency> collectManagingDependencies(@NotNull MavenDomProjectModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.collectManagingDependencies must not be null");
        }
        HashSet dependencies = new HashSet();
        Processor<MavenDomDependencies> collectProcessor = new Processor<MavenDomDependencies>((Set)dependencies){
            final /* synthetic */ Set val$dependencies;
            {
                this.val$dependencies = set;
            }

            public boolean process(MavenDomDependencies mavenDomDependencies) {
                this.val$dependencies.addAll(mavenDomDependencies.getDependencies());
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(model, collectProcessor, model.getManager().getProject());
        HashSet hashSet = dependencies;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.collectManagingDependencies must not return null");
        }
        return hashSet;
    }

    @Nullable
    public static MavenDomDependency searchManagingDependency(final @NotNull MavenDomDependency dependency, @NotNull Project project) {
        MavenDomProjectModel model;
        if (dependency == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.searchManagingDependency must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.searchManagingDependency must not be null");
        }
        final MavenDomDependency[] parent = new MavenDomDependency[]{null};
        final String artifactId = dependency.getArtifactId().getStringValue();
        final String groupId = dependency.getGroupId().getStringValue();
        if (artifactId != null && groupId != null && (model = (MavenDomProjectModel)dependency.getParentOfType(MavenDomProjectModel.class, false)) != null) {
            Processor<MavenDomDependencies> processor = new Processor<MavenDomDependencies>(){

                public boolean process(MavenDomDependencies mavenDomDependencies) {
                    if (!model.equals(mavenDomDependencies.getParentOfType(MavenDomProjectModel.class, true))) {
                        for (MavenDomDependency domDependency : mavenDomDependencies.getDependencies()) {
                            if (domDependency.equals(dependency) || !artifactId.equals(domDependency.getArtifactId().getStringValue()) || !groupId.equals(domDependency.getGroupId().getStringValue())) continue;
                            parent[0] = domDependency;
                            return true;
                        }
                    }
                    return false;
                }
            };
            MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(model, processor, project);
        }
        return parent[0];
    }

    public static boolean processDependenciesInDependencyManagement(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<MavenDomDependencies> processor, @NotNull Project project) {
        if (projectDom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement must not be null");
        }
        Function<MavenDomProfile, MavenDomDependencies> domProfileFunction = new Function<MavenDomProfile, MavenDomDependencies>(){

            public MavenDomDependencies fun(MavenDomProfile mavenDomProfile) {
                return mavenDomProfile.getDependencyManagement().getDependencies();
            }
        };
        Function<MavenDomProjectModel, MavenDomDependencies> projectDomFunction = new Function<MavenDomProjectModel, MavenDomDependencies>(){

            public MavenDomDependencies fun(MavenDomProjectModel mavenDomProjectModel) {
                return mavenDomProjectModel.getDependencyManagement().getDependencies();
            }
        };
        return MavenDomProjectProcessorUtils.process(projectDom, processor, project, domProfileFunction, projectDomFunction);
    }

    public static boolean processProperties(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<MavenDomProperties> processor, @NotNull Project project) {
        if (projectDom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processProperties must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processProperties must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processProperties must not be null");
        }
        Function<MavenDomProfile, MavenDomProperties> domProfileFunction = new Function<MavenDomProfile, MavenDomProperties>(){

            public MavenDomProperties fun(MavenDomProfile mavenDomProfile) {
                return mavenDomProfile.getProperties();
            }
        };
        Function<MavenDomProjectModel, MavenDomProperties> projectDomFunction = new Function<MavenDomProjectModel, MavenDomProperties>(){

            public MavenDomProperties fun(MavenDomProjectModel mavenDomProjectModel) {
                return mavenDomProjectModel.getProperties();
            }
        };
        return MavenDomProjectProcessorUtils.process(projectDom, processor, project, domProfileFunction, projectDomFunction);
    }

    public static <T> boolean process(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<T> processor, @NotNull Project project, @NotNull Function<MavenDomProfile, T> domProfileFunction, @NotNull Function<MavenDomProjectModel, T> projectDomFunction) {
        if (projectDom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        if (domProfileFunction == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        if (projectDomFunction == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        return MavenDomProjectProcessorUtils.process(projectDom, processor, project, domProfileFunction, projectDomFunction, (Set<MavenDomProjectModel>)new HashSet());
    }

    public static <T> boolean process(@NotNull MavenDomProjectModel projectDom, @NotNull Processor<T> processor, @NotNull Project project, @NotNull Function<MavenDomProfile, T> domProfileFunction, @NotNull Function<MavenDomProjectModel, T> projectDomFunction, Set<MavenDomProjectModel> processed) {
        if (projectDom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        if (domProfileFunction == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        if (projectDomFunction == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.process must not be null");
        }
        if (processed.contains(projectDom)) {
            return true;
        }
        processed.add(projectDom);
        MavenProject mavenProjectOrNull = MavenDomUtil.findProject(projectDom);
        if (MavenDomProjectProcessorUtils.processSettingsXml(mavenProjectOrNull, processor, project, domProfileFunction)) {
            return true;
        }
        if (MavenDomProjectProcessorUtils.processProject(projectDom, mavenProjectOrNull, processor, project, domProfileFunction, projectDomFunction)) {
            return true;
        }
        return MavenDomProjectProcessorUtils.processParentProjectFile(projectDom, processor, project, domProfileFunction, projectDomFunction, processed);
    }

    private static <T> boolean processParentProjectFile(MavenDomProjectModel projectDom, final Processor<T> processor, final Project project, final Function<MavenDomProfile, T> domProfileFunction, final Function<MavenDomProjectModel, T> projectDomFunction, final Set<MavenDomProjectModel> processed) {
        Boolean aBoolean = new MyMavenParentProjectFileProcessor<Boolean>(project){

            @Override
            protected Boolean doProcessParent(VirtualFile parentFile) {
                MavenDomProjectModel parentProjectDom = MavenDomUtil.getMavenDomProjectModel(project, parentFile);
                if (parentProjectDom == null) {
                    return false;
                }
                return MavenDomProjectProcessorUtils.process(parentProjectDom, processor, project, domProfileFunction, projectDomFunction, processed);
            }
        }.process(projectDom);
        return aBoolean == null ? false : aBoolean;
    }

    private static <T> boolean processSettingsXml(@Nullable MavenProject mavenProject, @NotNull Processor<T> processor, @NotNull Project project, Function<MavenDomProfile, T> domProfileFunction) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processSettingsXml must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils.processSettingsXml must not be null");
        }
        MavenGeneralSettings settings = MavenProjectsManager.getInstance(project).getGeneralSettings();
        for (VirtualFile each : settings.getEffectiveSettingsFiles()) {
            MavenDomSettingsModel settingsDom = MavenDomUtil.getMavenDomModel(project, each, MavenDomSettingsModel.class);
            if (settingsDom == null || !MavenDomProjectProcessorUtils.processProfiles(settingsDom.getProfiles(), mavenProject, processor, domProfileFunction)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean processProject(MavenDomProjectModel projectDom, MavenProject mavenProjectOrNull, Processor<T> processor, Project project, Function<MavenDomProfile, T> domProfileFunction, Function<MavenDomProjectModel, T> projectDomFunction) {
        if (MavenDomProjectProcessorUtils.processProfilesXml(MavenDomUtil.getVirtualFile(projectDom), mavenProjectOrNull, processor, project, domProfileFunction)) {
            return true;
        }
        if (MavenDomProjectProcessorUtils.processProfiles(projectDom.getProfiles(), mavenProjectOrNull, processor, domProfileFunction)) {
            return true;
        }
        Object t = projectDomFunction.fun((Object)projectDom);
        return t == null ? false : processor.process(t);
    }

    private static <T> boolean processProfilesXml(VirtualFile projectFile, MavenProject mavenProjectOrNull, Processor<T> processor, Project project, Function<MavenDomProfile, T> f) {
        VirtualFile profilesFile = MavenUtil.findProfilesXmlFile(projectFile);
        if (profilesFile == null) {
            return false;
        }
        MavenDomProfiles profiles = MavenDomUtil.getMavenDomProfilesModel(project, profilesFile);
        if (profiles == null) {
            return false;
        }
        return MavenDomProjectProcessorUtils.processProfiles(profiles, mavenProjectOrNull, processor, f);
    }

    private static <T> boolean processProfiles(MavenDomProfiles profilesDom, MavenProject mavenProjectOrNull, Processor<T> processor, Function<MavenDomProfile, T> f) {
        Collection<String> activePropfiles = mavenProjectOrNull == null ? null : mavenProjectOrNull.getActiveProfilesIds();
        for (MavenDomProfile each : profilesDom.getProfiles()) {
            Object t;
            XmlTag idTag = each.getId().getXmlTag();
            if (idTag == null || activePropfiles != null && !activePropfiles.contains(idTag.getValue().getText()) || (t = f.fun((Object)each)) == null || !processor.process(t)) continue;
            return true;
        }
        return false;
    }

    private static abstract class MyMavenParentProjectFileProcessor<T>
    extends MavenParentProjectFileProcessor<Boolean> {
        private final Project myProject;

        public MyMavenParentProjectFileProcessor(Project project) {
            this.myProject = project;
        }

        @Override
        protected VirtualFile findManagedFile(@NotNull MavenId id) {
            if (id == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils$MyMavenParentProjectFileProcessor.findManagedFile must not be null");
            }
            MavenProject project = MavenProjectsManager.getInstance(this.myProject).findProject(id);
            return project == null ? null : project.getFile();
        }

        @Nullable
        public Boolean process(@NotNull MavenDomProjectModel projectDom) {
            if (projectDom == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/MavenDomProjectProcessorUtils$MyMavenParentProjectFileProcessor.process must not be null");
            }
            MavenDomParent parent = projectDom.getMavenParent();
            MavenParentDesc parentDesc = null;
            if (DomUtil.hasXml((DomElement)parent)) {
                String parentGroupId = parent.getGroupId().getStringValue();
                String parentArtifactId = parent.getArtifactId().getStringValue();
                String parentVersion = parent.getVersion().getStringValue();
                String parentRelativePath = parent.getRelativePath().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)parentRelativePath)) {
                    parentRelativePath = "../pom.xml";
                }
                MavenId parentId = new MavenId(parentGroupId, parentArtifactId, parentVersion);
                parentDesc = new MavenParentDesc(parentId, parentRelativePath);
            }
            return (Boolean)this.process(MavenProjectsManager.getInstance(this.myProject).getGeneralSettings(), MavenDomUtil.getVirtualFile(projectDom), parentDesc);
        }
    }
}

