/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.compiler;

import com.intellij.compiler.CompilerIOUtil;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenResource;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenResourceCompiler
implements ClassPostProcessingCompiler {
    private static final Key<List<String>> FILES_TO_DELETE_KEY = Key.create((String)(MavenResourceCompiler.class.getSimpleName() + ".FILES_TO_DELETE"));
    private Map<String, Set<String>> myOutputItemsCache = new THashMap();

    public MavenResourceCompiler(Project project) {
        this.loadCache(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache(Project project) {
        File file = MavenResourceCompiler.getCacheFile(project);
        if (!file.exists()) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            try {
                if (in.readInt() != 54) {
                    return;
                }
                int modulesSize = in.readInt();
                THashMap temp = new THashMap();
                while (modulesSize-- > 0) {
                    String module = CompilerIOUtil.readString((DataInput)in);
                    int pathsSize = in.readInt();
                    Set<String> paths = MavenResourceCompiler.createPathsSet(pathsSize);
                    while (pathsSize-- > 0) {
                        paths.add(CompilerIOUtil.readString((DataInput)in));
                    }
                    temp.put(module, paths);
                }
                this.myOutputItemsCache = temp;
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    private static Set<String> createPathsSet(int size) {
        return SystemInfo.isFileSystemCaseSensitive ? new THashSet(size) : new THashSet(size, (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCache(Project project) {
        File file = MavenResourceCompiler.getCacheFile(project);
        file.getParentFile().mkdirs();
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeInt(54);
                out.writeInt(this.myOutputItemsCache.size());
                for (Map.Entry<String, Set<String>> eachEntry : this.myOutputItemsCache.entrySet()) {
                    String module = eachEntry.getKey();
                    Set<String> paths = eachEntry.getValue();
                    CompilerIOUtil.writeString((String)module, (DataOutput)out);
                    out.writeInt(paths.size());
                    for (String eachPath : paths) {
                        CompilerIOUtil.writeString((String)eachPath, (DataOutput)out);
                    }
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            MavenLog.LOG.error((Throwable)e);
        }
    }

    private static File getCacheFile(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory((Project)project), "maven_compiler_caches.dat");
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        FileProcessingCompiler.ProcessingItem[] processingItemArray;
        final Project project = context.getProject();
        final MavenProjectsManager mavenProjectManager = MavenProjectsManager.getInstance(project);
        if (!mavenProjectManager.isMavenizedProject()) {
            processingItemArray = FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/compiler/MavenResourceCompiler.getProcessingItems must not return null");
            return processingItemArray;
        }
        processingItemArray = (FileProcessingCompiler.ProcessingItem[])new ReadAction<FileProcessingCompiler.ProcessingItem[]>(){

            protected void run(Result<FileProcessingCompiler.ProcessingItem[]> resultObject) throws Throwable {
                ArrayList allItemsToProcess = new ArrayList();
                ArrayList filesToDelete = new ArrayList();
                for (Module eachModule : context.getCompileScope().getAffectedModules()) {
                    MavenProject mavenProject = mavenProjectManager.findProject(eachModule);
                    if (mavenProject == null) continue;
                    Properties properties = MavenResourceCompiler.loadPropertiesAndFilters(context, mavenProject);
                    List nonFilteredExtensions = MavenResourceCompiler.collectNonFilteredExtensions(mavenProject);
                    String escapeString = MavenJDOMUtil.findChildValueByPath(mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin"), "escapeString", "\\");
                    long propertiesHashCode = MavenResourceCompiler.calculateHashCode(mavenProject, properties);
                    ArrayList moduleItemsToProcess = new ArrayList();
                    MavenResourceCompiler.this.collectProcessingItems(eachModule, mavenProject, context, properties, propertiesHashCode, nonFilteredExtensions, escapeString, false, moduleItemsToProcess);
                    MavenResourceCompiler.this.collectProcessingItems(eachModule, mavenProject, context, properties, propertiesHashCode, nonFilteredExtensions, escapeString, true, moduleItemsToProcess);
                    MavenResourceCompiler.this.collectItemsToDelete(eachModule, moduleItemsToProcess, filesToDelete);
                    allItemsToProcess.addAll(moduleItemsToProcess);
                }
                if (!filesToDelete.isEmpty()) {
                    allItemsToProcess.add(new FakeProcessingItem());
                }
                context.putUserData(FILES_TO_DELETE_KEY, filesToDelete);
                resultObject.setResult((Object)allItemsToProcess.toArray(new FileProcessingCompiler.ProcessingItem[allItemsToProcess.size()]));
                MavenResourceCompiler.this.removeObsoleteModulesFromCache(project);
                MavenResourceCompiler.this.saveCache(project);
            }
        }.execute().getResultObject();
        if (processingItemArray != null) return processingItemArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/compiler/MavenResourceCompiler.getProcessingItems must not return null");
    }

    private static List<String> collectNonFilteredExtensions(MavenProject mavenProject) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList("jpg", "jpeg", "gif", "bmp", "png"));
        Element config = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (config == null) {
            return result;
        }
        for (String each : MavenJDOMUtil.findChildrenValuesByPath(config, "nonFilteredFileExtensions", "nonFilteredFileExtension")) {
            result.add(each);
        }
        return result;
    }

    private static long calculateHashCode(MavenProject project, Properties properties) {
        TreeSet<String> sorted = new TreeSet<String>();
        for (Map.Entry<Object, Object> each : properties.entrySet()) {
            sorted.add(each.getKey().toString() + "->" + each.getValue().toString());
        }
        return project.getLastReadStamp() + (long)(31 * ((Object)sorted).hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesAndFilters(CompileContext context, MavenProject mavenProject) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)mavenProject.getProperties());
        for (String each : mavenProject.getFilters()) {
            try {
                FileInputStream in = new FileInputStream(each);
                try {
                    properties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                String url = VfsUtil.pathToUrl((String)mavenProject.getFile().getPath());
                context.addMessage(CompilerMessageCategory.WARNING, "Maven: Cannot read the filter. " + e.getMessage(), url, -1, -1);
            }
        }
        return properties;
    }

    private void collectProcessingItems(Module module, MavenProject mavenProject, CompileContext context, Properties properties, long propertiesHashCode, List<String> nonFilteredExtensions, String escapeString, boolean tests, List<FileProcessingCompiler.ProcessingItem> result) {
        String outputDir = CompilerPaths.getModuleOutputPath((Module)module, (boolean)tests);
        if (outputDir == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "Maven: Module '" + module.getName() + "'output is not specified", null, -1, -1);
            return;
        }
        List<MavenResource> resources = tests ? mavenProject.getTestResources() : mavenProject.getResources();
        for (MavenResource each : resources) {
            VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(each.getDirectory());
            if (dir == null) continue;
            List<Pattern> includes = this.collectPatterns(each.getIncludes(), "**/*");
            List<Pattern> excludes = this.collectPatterns(each.getExcludes(), null);
            String targetPath = each.getTargetPath();
            String resourceOutputDir = StringUtil.isEmptyOrSpaces((String)targetPath) ? outputDir : (FileUtil.isAbsolute((String)targetPath) ? targetPath : outputDir + "/" + targetPath);
            this.collectProcessingItems(module, dir, dir, resourceOutputDir, includes, excludes, each.isFiltered(), properties, propertiesHashCode, nonFilteredExtensions, escapeString, result, context.getProgressIndicator());
        }
    }

    private List<Pattern> collectPatterns(List<String> values, String defaultValue) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        if (values == null || values.isEmpty()) {
            if (defaultValue == null) {
                return Collections.emptyList();
            }
            return MavenUtil.collectPattern(defaultValue, result);
        }
        for (String each : values) {
            MavenUtil.collectPattern(each, result);
        }
        return result;
    }

    private void collectProcessingItems(Module module, VirtualFile sourceRoot, VirtualFile currentDir, String outputDir, List<Pattern> includes, List<Pattern> excludes, boolean isSourceRootFiltered, Properties properties, long propertiesHashCode, List<String> nonFilteredExtensions, String escapeString, List<FileProcessingCompiler.ProcessingItem> result, ProgressIndicator indicator) {
        indicator.checkCanceled();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        for (VirtualFile eachSourceFile : currentDir.getChildren()) {
            if (eachSourceFile.isDirectory()) {
                this.collectProcessingItems(module, sourceRoot, eachSourceFile, outputDir, includes, excludes, isSourceRootFiltered, properties, propertiesHashCode, nonFilteredExtensions, escapeString, result, indicator);
                continue;
            }
            String relPath = VfsUtil.getRelativePath((VirtualFile)eachSourceFile, (VirtualFile)sourceRoot, (char)'/');
            if (fileIndex.isIgnored(eachSourceFile) || !MavenUtil.isIncluded(relPath, includes, excludes)) continue;
            String outputPath = outputDir + "/" + relPath;
            long outputFileTimestamp = -1L;
            File outputFile = new File(outputPath);
            if (outputFile.exists()) {
                outputFileTimestamp = outputFile.lastModified();
            }
            boolean isFileterd = isSourceRootFiltered && !nonFilteredExtensions.contains(eachSourceFile.getExtension());
            result.add(new MyProcessingItem(module, eachSourceFile, outputPath, outputFileTimestamp, isFileterd, properties, propertiesHashCode, escapeString));
        }
    }

    private void collectItemsToDelete(Module module, List<FileProcessingCompiler.ProcessingItem> processingItems, List<String> result) {
        Set<String> currentPaths = MavenResourceCompiler.createPathsSet(processingItems.size());
        for (FileProcessingCompiler.ProcessingItem each : processingItems) {
            if (!(each instanceof MyProcessingItem)) continue;
            currentPaths.add(((MyProcessingItem)each).getOutputPath());
        }
        Set<String> cachedPaths = null;
        THashSet otherModulesCachedPaths = new THashSet();
        for (Map.Entry<String, Set<String>> eachEntry : this.myOutputItemsCache.entrySet()) {
            if (eachEntry.getKey().equals(module.getName())) {
                cachedPaths = eachEntry.getValue();
                continue;
            }
            otherModulesCachedPaths.addAll((Collection)eachEntry.getValue());
        }
        this.myOutputItemsCache.put(module.getName(), currentPaths);
        if (cachedPaths == null) {
            return;
        }
        cachedPaths.removeAll(currentPaths);
        cachedPaths.removeAll((Collection<?>)otherModulesCachedPaths);
        result.addAll(cachedPaths);
    }

    private void removeObsoleteModulesFromCache(Project project) {
        THashSet existingModules = new THashSet();
        for (Module each : ModuleManager.getInstance((Project)project).getModules()) {
            existingModules.add(each.getName());
        }
        for (String each : new THashSet(this.myOutputItemsCache.keySet())) {
            if (existingModules.contains(each)) continue;
            this.myOutputItemsCache.remove(each);
        }
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        context.getProgressIndicator().setText("Processing Maven resources...");
        ArrayList<FileProcessingCompiler.ProcessingItem> result = new ArrayList<FileProcessingCompiler.ProcessingItem>(items.length);
        ArrayList<File> filesToRefresh = new ArrayList<File>(items.length);
        this.deleteOutdatedFile((List)context.getUserData(FILES_TO_DELETE_KEY), filesToRefresh);
        boolean count = false;
        for (FileProcessingCompiler.ProcessingItem each : items) {
            if (!(each instanceof MyProcessingItem)) continue;
            context.getProgressIndicator().setFraction((double)count / (double)items.length);
            context.getProgressIndicator().checkCanceled();
            MyProcessingItem eachItem = (MyProcessingItem)each;
            VirtualFile sourceVirtualFile = eachItem.getFile();
            File sourceFile = new File(sourceVirtualFile.getPath());
            File outputFile = new File(eachItem.getOutputPath());
            try {
                outputFile.getParentFile().mkdirs();
                boolean shouldFilter = eachItem.isFiltered();
                if (sourceFile.length() > 0xA00000L) {
                    context.addMessage(CompilerMessageCategory.WARNING, "Maven: File is too big to be filtered. Most likely it is a binary file and should be excluded from filtering.", sourceVirtualFile.getUrl(), -1, -1);
                    shouldFilter = false;
                }
                if (shouldFilter) {
                    String charset = sourceVirtualFile.getCharset().name();
                    String text = new String(FileUtil.loadFileBytes((File)sourceFile), charset);
                    String escapedCharacters = "properties".equals(sourceVirtualFile.getExtension()) ? "\\" : null;
                    text = MavenPropertyResolver.resolve(eachItem.getModule(), text, eachItem.getProperties(), eachItem.getEscapeString(), escapedCharacters);
                    FileUtil.writeToFile((File)outputFile, (byte[])text.getBytes(charset));
                } else {
                    FileUtil.copy((File)sourceFile, (File)outputFile);
                }
                ((MyValididtyState)each.getValidityState()).setOutputFileTimestamp(outputFile.lastModified());
                result.add(each);
                filesToRefresh.add(outputFile);
            }
            catch (IOException e) {
                context.addMessage(CompilerMessageCategory.ERROR, "Maven: Cannot process resource file: " + e.getMessage(), sourceVirtualFile.getUrl(), -1, -1);
            }
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
        return result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
    }

    private void deleteOutdatedFile(List<String> filesToDelete, List<File> filesToRefresh) {
        for (String each : filesToDelete) {
            File file = new File(each);
            if (!FileUtil.delete((File)file)) continue;
            filesToRefresh.add(file);
        }
    }

    @NotNull
    public String getDescription() {
        if ("Maven Resource Compiler" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/compiler/MavenResourceCompiler.getDescription must not return null");
        }
        return "Maven Resource Compiler";
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return MyValididtyState.load(in);
    }

    private static class MyValididtyState
    implements ValidityState {
        private final long mySourceFileTimestamp;
        private volatile long myOutputFileTimestamp;
        private final boolean myFiltered;
        private final long myPropertiesHashCode;
        private final String myEscapeString;

        public static MyValididtyState load(DataInput in) throws IOException {
            return new MyValididtyState(in.readLong(), in.readLong(), in.readBoolean(), in.readLong(), in.readUTF());
        }

        public void setOutputFileTimestamp(long outputFileTimestamp) {
            this.myOutputFileTimestamp = outputFileTimestamp;
        }

        private MyValididtyState(long sourceFileTimestamp, long outputFileTimestamp, boolean isFiltered, long propertiesHashCode, String escapeString) {
            this.mySourceFileTimestamp = sourceFileTimestamp;
            this.myOutputFileTimestamp = outputFileTimestamp;
            this.myFiltered = isFiltered;
            this.myPropertiesHashCode = propertiesHashCode;
            this.myEscapeString = escapeString;
        }

        public String toString() {
            return this.mySourceFileTimestamp + " " + this.myOutputFileTimestamp + " " + this.myFiltered + " " + this.myPropertiesHashCode + " " + this.myEscapeString;
        }

        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof MyValididtyState)) {
                return false;
            }
            MyValididtyState that = (MyValididtyState)otherState;
            return this.mySourceFileTimestamp == that.mySourceFileTimestamp && this.myOutputFileTimestamp == that.myOutputFileTimestamp && this.myFiltered == that.myFiltered && this.myPropertiesHashCode == that.myPropertiesHashCode && Comparing.strEqual((String)this.myEscapeString, (String)that.myEscapeString);
        }

        public void save(DataOutput out) throws IOException {
            out.writeLong(this.mySourceFileTimestamp);
            out.writeLong(this.myOutputFileTimestamp);
            out.writeBoolean(this.myFiltered);
            out.writeLong(this.myPropertiesHashCode);
            out.writeUTF(this.myEscapeString);
        }
    }

    private static class FakeProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private LightVirtualFile myFile = new LightVirtualFile(this.getClass().getName());

        private FakeProcessingItem() {
        }

        @NotNull
        public VirtualFile getFile() {
            LightVirtualFile lightVirtualFile = this.myFile;
            if (lightVirtualFile == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/compiler/MavenResourceCompiler$FakeProcessingItem.getFile must not return null");
            }
            return lightVirtualFile;
        }

        public ValidityState getValidityState() {
            return null;
        }
    }

    private static class MyProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final Module myModule;
        private final VirtualFile mySourceFile;
        private final String myOutputPath;
        private final boolean myFiltered;
        private final Properties myProperties;
        private final String myEscapeString;
        private final MyValididtyState myState;

        public MyProcessingItem(Module module, VirtualFile sourceFile, String outputPath, long outputFileTimestamp, boolean isFiltered, Properties properties, long propertiesHashCode, String escapeString) {
            this.myModule = module;
            this.mySourceFile = sourceFile;
            this.myOutputPath = outputPath;
            this.myFiltered = isFiltered;
            this.myProperties = properties;
            this.myEscapeString = escapeString;
            this.myState = new MyValididtyState(sourceFile.getTimeStamp(), outputFileTimestamp, isFiltered, propertiesHashCode, escapeString);
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.mySourceFile;
            if (virtualFile == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/compiler/MavenResourceCompiler$MyProcessingItem.getFile must not return null");
            }
            return virtualFile;
        }

        public String getOutputPath() {
            return this.myOutputPath;
        }

        public Module getModule() {
            return this.myModule;
        }

        public boolean isFiltered() {
            return this.myFiltered;
        }

        public Properties getProperties() {
            return this.myProperties;
        }

        public String getEscapeString() {
            return this.myEscapeString;
        }

        public ValidityState getValidityState() {
            return this.myState;
        }
    }
}

