/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.importToCvs;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.ImportConfiguration;
import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.cvsSupport2.ui.experts.WizardStep;
import com.intellij.cvsSupport2.ui.experts.importToCvs.CvsFieldValidator;
import com.intellij.cvsSupport2.ui.experts.importToCvs.SelectImportLocationStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportSettingsStep
extends WizardStep {
    private JPanel myPanel;
    private JTextField myModuleName;
    private JTextField myVendor;
    private JTextField myReleaseTag;
    private JTextArea myLogMessage;
    private boolean myIsInitialized = false;
    private File myDirectoryToImport;
    private final SelectImportLocationStep mySelectImportLocationStep;
    private final ImportConfiguration myImportConfiguration;
    private JCheckBox myCheckoutAfterImport;
    private JCheckBox myMakeCheckedOutFilesReadOnly;
    private JLabel myVendorErrorMessage;
    private JLabel myReleaseTagErrorMessage;
    private MyDocumentListener myDocumentListener;
    private JLabel myNameLabel;
    private JLabel myVendorLabel;
    private JLabel myReleaseTagLabel;
    private JLabel myLogMessageLabel;

    public ImportSettingsStep(CvsWizard wizard, SelectImportLocationStep selectImportLocationStep, ImportConfiguration importConfiguration) {
        super(CvsBundle.message((String)"dialog.title.import.settings", (Object[])new Object[0]), wizard);
        this.$$$setupUI$$$();
        this.myCheckoutAfterImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportSettingsStep.this.updateCheckoutSettingsVisibility();
            }
        });
        this.mySelectImportLocationStep = selectImportLocationStep;
        this.myImportConfiguration = importConfiguration;
        this.checkFields(null);
        this.addListenerTo(this.myVendor);
        this.addListenerTo(this.myReleaseTag);
        this.myLogMessageLabel.setLabelFor(this.myLogMessage);
        this.myNameLabel.setLabelFor(this.myModuleName);
        this.myReleaseTagLabel.setLabelFor(this.myReleaseTag);
        this.myVendorLabel.setLabelFor(this.myVendor);
        this.myLogMessage.setWrapStyleWord(true);
        this.myLogMessage.setLineWrap(true);
        this.init();
    }

    private void updateCheckoutSettingsVisibility() {
        this.myMakeCheckedOutFilesReadOnly.setVisible(this.myCheckoutAfterImport.isSelected());
    }

    @Override
    protected void dispose() {
    }

    private void addListenerTo(JTextField editor) {
        this.myDocumentListener = new MyDocumentListener(editor);
        editor.getDocument().addDocumentListener(this.myDocumentListener);
    }

    @Override
    public void saveState() {
        super.saveState();
        this.myImportConfiguration.RELEASE_TAG = this.getReleaseTag();
        this.myImportConfiguration.VENDOR = this.getVendor();
        this.myImportConfiguration.LOG_MESSAGE = this.getLogMessage();
        this.myImportConfiguration.CHECKOUT_AFTER_IMPORT = this.myCheckoutAfterImport.isSelected();
        this.myImportConfiguration.MAKE_NEW_FILES_READ_ONLY = this.myMakeCheckedOutFilesReadOnly.isSelected();
    }

    private boolean checkFields() {
        JTextField[] fields = new JTextField[]{this.myReleaseTag, this.myVendor};
        boolean result = true;
        result &= CvsFieldValidator.checkField(this.myVendor, fields, true, this.myVendorErrorMessage, null);
        return result &= CvsFieldValidator.checkField(this.myReleaseTag, fields, true, this.myReleaseTagErrorMessage, null);
    }

    private void checkFields(JComponent editor) {
        if (!this.checkFields()) {
            this.getWizard().disableNextAndFinish();
        } else {
            this.getWizard().enableNextAndFinish();
        }
        if (editor != null) {
            editor.requestFocus();
        }
    }

    @Override
    public boolean nextIsEnabled() {
        return this.checkFields();
    }

    @Override
    public boolean setActive() {
        if (!this.myIsInitialized) {
            this.myIsInitialized = true;
            this.myReleaseTag.setText(this.myImportConfiguration.RELEASE_TAG);
            this.myVendor.setText(this.myImportConfiguration.VENDOR);
            this.myLogMessage.setText(this.myImportConfiguration.LOG_MESSAGE);
            this.myCheckoutAfterImport.setSelected(this.myImportConfiguration.CHECKOUT_AFTER_IMPORT);
            this.myMakeCheckedOutFilesReadOnly.setSelected(this.myImportConfiguration.MAKE_NEW_FILES_READ_ONLY);
            this.updateCheckoutSettingsVisibility();
            this.selectAll();
        }
        if (!Comparing.equal((Object)this.myDirectoryToImport, (Object)this.mySelectImportLocationStep.getSelectedFile())) {
            this.myDirectoryToImport = this.mySelectImportLocationStep.getSelectedFile();
            this.myModuleName.setText(this.myDirectoryToImport.getName());
            this.myModuleName.selectAll();
        }
        return true;
    }

    private void selectAll() {
        this.myLogMessage.selectAll();
        this.myModuleName.selectAll();
        this.myReleaseTag.selectAll();
        this.myVendor.selectAll();
    }

    @Override
    protected JComponent createComponent() {
        return this.myPanel;
    }

    public String getVendor() {
        return this.myVendor.getText().trim();
    }

    public String getReleaseTag() {
        return this.myReleaseTag.getText().trim();
    }

    public String getLogMessage() {
        return this.myLogMessage.getText().trim();
    }

    public String getModuleName() {
        return this.myModuleName.getText().trim();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JTextArea jTextArea;
        JLabel jLabel2;
        JLabel jLabel3;
        JTextField jTextField;
        JLabel jLabel4;
        JTextField jTextField2;
        JLabel jLabel5;
        JTextField jTextField3;
        JLabel jLabel6;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNameLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.import.options.name.in.repository"));
        jPanel2.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleName = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVendorLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.import.options.vendor"));
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVendor = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myReleaseTagLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.import.options.release.tag"));
        jPanel2.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReleaseTag = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("");
        jPanel2.add((Component)jLabel7, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, new Dimension(250, -1), null, null));
        this.myVendorErrorMessage = jLabel3 = new JLabel();
        jLabel3.setText("##################");
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, new Dimension(250, -1), null, null));
        this.myReleaseTagErrorMessage = jLabel2 = new JLabel();
        jLabel2.setText("###############");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, new Dimension(250, -1), null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(3, 1, 2, 2, 0, 3, 7, 7, null, null, null));
        this.myLogMessage = jTextArea = new JTextArea();
        jTextArea.setRows(5);
        jScrollPane.setViewportView(jTextArea);
        this.myLogMessageLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.import.options.log.message"));
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCheckoutAfterImport = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.import.options.checkout.after.import"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMakeCheckedOutFilesReadOnly = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.import.options.make.checked.out.files.read.only"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private final JComponent myComponent;

        public MyDocumentListener(JComponent component) {
            this.myComponent = component;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ImportSettingsStep.this.checkFields(this.myComponent);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ImportSettingsStep.this.checkFields(this.myComponent);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ImportSettingsStep.this.checkFields(this.myComponent);
        }
    }
}

