/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.checkout;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsFile;
import com.intellij.cvsSupport2.ui.ChangeKeywordSubstitutionPanel;
import com.intellij.cvsSupport2.ui.experts.WizardStep;
import com.intellij.cvsSupport2.ui.experts.checkout.CheckoutWizard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.checkout.CheckoutStrategy;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;

public class ChooseCheckoutMode
extends WizardStep {
    private File mySelectedLocation;
    private final Collection<File> myCvsPaths = new ArrayList<File>();
    private final DefaultListModel myCheckoutModeModel = new DefaultListModel();
    private final JList myCheckoutModeList = new JList(this.myCheckoutModeModel);
    private final JCheckBox myMakeNewFielsReadOnly = new JCheckBox(CvsBundle.message((String)"checkbox.make.new.files.read.only", (Object[])new Object[0]));
    private final JCheckBox myPruneEmptyDirectories = new JCheckBox(CvsBundle.message((String)"checkbox.prune.empty.directories", (Object[])new Object[0]));
    private final ChangeKeywordSubstitutionPanel myChangeKeywordSubstitutionPanel;
    private final CheckoutWizard myOwner;
    private final JPanel myCenterPanel = new JPanel(new CardLayout());
    private static final Icon FOLDER_ICON = Icons.DIRECTORY_CLOSED_ICON;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.ui.experts.checkout.ChooseCheckoutMode");
    @NonNls
    public static final String LIST = "LIST";
    @NonNls
    public static final String MESSAGE = "MESSSAGE";
    private final JLabel myMessage = new JLabel("XXX");
    @NonNls
    private static final String DUMMY_LABEL_TEXT = "XXX";

    public ChooseCheckoutMode(CheckoutWizard wizard) {
        super("###", wizard);
        this.myOwner = wizard;
        this.myCheckoutModeList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                CheckoutStrategy checkoutStrategy = (CheckoutStrategy)value;
                this.append(checkoutStrategy.getResult().getAbsolutePath(), new SimpleTextAttributes(0, list.getForeground()));
                this.setIcon(FOLDER_ICON);
            }
        });
        this.myCheckoutModeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChooseCheckoutMode.this.myOwner.updateStep();
            }
        });
        this.myCheckoutModeList.setSelectionMode(0);
        CvsApplicationLevelConfiguration config = CvsApplicationLevelConfiguration.getInstance();
        this.myMakeNewFielsReadOnly.setSelected(config.MAKE_CHECKED_OUT_FILES_READONLY);
        this.myPruneEmptyDirectories.setSelected(config.CHECKOUT_PRUNE_EMPTY_DIRECTORIES);
        this.myChangeKeywordSubstitutionPanel = new ChangeKeywordSubstitutionPanel(config.CHECKOUT_KEYWORD_SUBSTITUTION);
        this.myCenterPanel.add(LIST, ScrollPaneFactory.createScrollPane((JComponent)this.myCheckoutModeList));
        JPanel messagePanel = new JPanel(new BorderLayout(2, 4));
        messagePanel.add((Component)this.myMessage, "North");
        messagePanel.setBackground(UIUtil.getTableBackground());
        this.myMessage.setBackground(UIUtil.getTableBackground());
        this.myCenterPanel.add(MESSAGE, ScrollPaneFactory.createScrollPane((JComponent)messagePanel));
        this.init();
    }

    @Override
    protected void dispose() {
    }

    @Override
    public boolean nextIsEnabled() {
        if (this.myCvsPaths.size() == 1) {
            return this.myCheckoutModeList.getSelectedValue() != null;
        }
        return true;
    }

    @Override
    protected JComponent createComponent() {
        JPanel result = new JPanel(new BorderLayout(4, 2));
        result.add((Component)this.myCenterPanel, "Center");
        result.add((Component)this.createOptionsPanel(), "South");
        return result;
    }

    private JPanel createOptionsPanel() {
        JPanel result = new JPanel(new GridLayout(0, 1));
        result.add(this.myMakeNewFielsReadOnly);
        result.add(this.myPruneEmptyDirectories);
        result.add(this.myChangeKeywordSubstitutionPanel.getPanel());
        return result;
    }

    @Override
    public Component getPreferredFocusedComponent() {
        return this.myCheckoutModeList;
    }

    @Override
    public boolean setActive() {
        File selectedLocation = this.myOwner.getSelectedLocation();
        Collection<File> cvsPaths = this.getSelectedFiles();
        if (!Comparing.equal((Object)selectedLocation, (Object)this.mySelectedLocation) || !Comparing.equal(cvsPaths, this.myCvsPaths) && selectedLocation != null) {
            this.mySelectedLocation = selectedLocation;
            LOG.assertTrue(this.mySelectedLocation != null);
            this.myCvsPaths.clear();
            this.myCvsPaths.addAll(cvsPaths);
            if (this.myCvsPaths.size() == 1) {
                this.show(LIST);
                this.rebuildList();
            } else {
                this.setStepTitle(CvsBundle.message((String)"info.text.selected.modules.will.be.checked.out.to", (Object[])new Object[0]));
                StringBuffer message = this.composeLocationsMessage();
                this.myMessage.setText(message.toString());
                this.show(MESSAGE);
                this.getWizard().enableNextAndFinish();
            }
        } else if (selectedLocation == null) {
            this.getWizard().disableNextAndFinish();
        }
        return true;
    }

    private StringBuffer composeLocationsMessage() {
        StringBuffer message = new StringBuffer();
        message.append("<html>");
        message.append("<p>");
        message.append(this.mySelectedLocation.getAbsolutePath());
        message.append("</p>");
        for (File file : this.myCvsPaths) {
            message.append("<p>");
            message.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-");
            message.append(file.getPath());
            message.append("</p>");
        }
        return message;
    }

    private Collection<File> getSelectedFiles() {
        HashSet allFiles = new HashSet();
        CvsElement[] selection = this.myOwner.getSelectedElements();
        if (selection == null) {
            return allFiles;
        }
        for (int i = 0; i < selection.length; ++i) {
            CvsElement cvsElement = selection[i];
            allFiles.add(new File(cvsElement.getCheckoutPath()));
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File file : allFiles) {
            if (this.hasParentIn((Collection<File>)allFiles, file)) continue;
            result.add(file);
        }
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File file, File file1) {
                return file.getPath().compareTo(file1.getPath());
            }
        });
        return result;
    }

    private boolean hasParentIn(Collection<File> allFiles, File file) {
        String filePath = file.getPath();
        for (File file1 : allFiles) {
            if (file1.equals(file) || !filePath.startsWith(file1.getPath())) continue;
            return true;
        }
        return false;
    }

    private void rebuildList() {
        File selected = this.myCvsPaths.iterator().next();
        this.setStepTitle(CvsBundle.message((String)"dialog.title.check.out.to", (Object[])new Object[]{selected}));
        this.myCheckoutModeModel.removeAllElements();
        CheckoutStrategy[] strategies = CheckoutStrategy.createAllStrategies((File)this.mySelectedLocation, (File)selected, (boolean)(this.myOwner.getSelectedElements()[0] instanceof CvsFile));
        HashSet results = new HashSet();
        ArrayList<CheckoutStrategy> resultModes = new ArrayList<CheckoutStrategy>();
        for (int i = 0; i < strategies.length; ++i) {
            CheckoutStrategy strategy = strategies[i];
            File resultFile = strategy.getResult();
            if (resultFile == null || results.contains(resultFile)) continue;
            results.add(resultFile);
            resultModes.add(strategy);
        }
        Collections.sort(resultModes);
        Iterator each = resultModes.iterator();
        while (each.hasNext()) {
            this.myCheckoutModeModel.addElement(each.next());
        }
        this.myCheckoutModeList.setSelectedIndex(0);
    }

    private void show(String mode) {
        ((CardLayout)this.myCenterPanel.getLayout()).show(this.myCenterPanel, mode);
    }

    public boolean getMakeNewFielsReadOnly() {
        return this.myMakeNewFielsReadOnly.isSelected();
    }

    public boolean getPruneEmptyDirectories() {
        return this.myPruneEmptyDirectories.isSelected();
    }

    public boolean useAlternativeCheckoutLocation() {
        if (this.myCvsPaths.size() == 1) {
            return ((CheckoutStrategy)this.myCheckoutModeList.getSelectedValue()).useAlternativeCheckoutLocation();
        }
        return false;
    }

    public File getCheckoutDirectory() {
        if (this.myCvsPaths.size() == 1) {
            return ((CheckoutStrategy)this.myCheckoutModeList.getSelectedValue()).getCheckoutDirectory();
        }
        return this.mySelectedLocation;
    }

    public String getKeywordSubstitution() {
        return this.myChangeKeywordSubstitutionPanel.getKeywordSubstitution();
    }
}

