/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.dateOrRevision;

import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.CommandWrapper;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;

public class SimpleRevision
implements RevisionOrDate {
    private final String myRevision;

    public static SimpleRevision createForTheSameVersionOf(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/cvsoperations/dateOrRevision/SimpleRevision.createForTheSameVersionOf must not be null");
        }
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(file.getParent(), file.getName());
        return new SimpleRevision(entry.getRevision());
    }

    public SimpleRevision(String revision) {
        this.myRevision = this.prepareRevision(revision);
    }

    private String prepareRevision(String revision) {
        if (revision == null) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)revision, (char)'-')) {
            return revision.substring(1);
        }
        return revision;
    }

    public String getRevision() {
        return this.myRevision;
    }

    public void setForCommand(Command command) {
        new CommandWrapper(command).setUpdateByRevisionOrDate(this.myRevision, null);
    }

    public CvsRevisionNumber getCvsRevisionNumber() {
        if (this.myRevision == null) {
            return null;
        }
        try {
            return new CvsRevisionNumber(this.myRevision);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

