/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsMessages;

import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesAdapter;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.FileMessage;
import com.intellij.cvsSupport2.errorHandling.CvsProcessException;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import org.netbeans.lib.cvsclient.ICvsCommandStopper;

public class CvsListenerWithProgress
extends CvsMessagesAdapter
implements ICvsCommandStopper,
ErrorRegistry {
    private ProgressIndicator myProgressIndicator;
    private String myLastError;
    private boolean myIndirectCancel;
    private boolean myPing;

    public CvsListenerWithProgress(ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator;
        this.myIndirectCancel = false;
        this.myPing = false;
    }

    public boolean isAlive() {
        return this.myPing;
    }

    public void resetAlive() {
        this.myPing = false;
    }

    public static CvsListenerWithProgress createOnProgress() {
        return new CvsListenerWithProgress(ProgressManager.getInstance().getProgressIndicator());
    }

    @Override
    public void addFileMessage(FileMessage message) {
        if (this.myProgressIndicator != null) {
            message.showMessageIn(this.myProgressIndicator);
        }
    }

    public ProgressIndicator getProgressIndicator() {
        if (this.myProgressIndicator == null) {
            this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        }
        return this.myProgressIndicator;
    }

    public void indirectCancel() {
        this.myIndirectCancel = true;
    }

    public boolean isAborted() {
        this.myPing = true;
        if (this.myLastError != null) {
            throw new CvsProcessException(this.myLastError);
        }
        if (this.myIndirectCancel) {
            return true;
        }
        ProgressIndicator progressIndicator = this.getProgressIndicator();
        if (progressIndicator == null) {
            return false;
        }
        return progressIndicator.isCanceled();
    }

    public void registerError(String description) {
        this.myLastError = description;
    }
}

