/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.update.UpdateSettings;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsMessagePattern;
import com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated;
import com.intellij.cvsSupport2.cvshandlers.IOFilesBasedDirectoryPruner;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.common.FindAllRoots;
import com.intellij.cvsSupport2.cvsoperations.common.FindAllRootsHelper;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.MergedWithConflictProjectOrModuleFile;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.UpdateOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.ui.CorruptedProjectFilesDialog;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;

public class UpdateHandler
extends CommandCvsHandler
implements PostCvsActivity {
    private final FilePath[] myFiles;
    private final Collection<VirtualFile> myRoots;
    private final Collection<File> myNotProcessedRepositories;
    private double myDirectoriesToBeProcessedCount;
    private static final CvsMessagePattern UPDATE_PATTERN = new CvsMessagePattern(new String[]{"cvs server: Updating ", "*"}, 2);
    private final Project myProject;
    private final Collection<MergedWithConflictProjectOrModuleFile> myCorruptedFiles;
    private final UpdatedFiles myUpdatedFiles;
    private final UpdateSettings myUpdateSettings;

    public UpdateHandler(FilePath[] files, UpdateSettings updateSettings, Project project, @NotNull UpdatedFiles updatedFiles) {
        if (updatedFiles == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/cvsSupport2/cvshandlers/UpdateHandler.<init> must not be null");
        }
        super(CvsBundle.message((String)"operation.name.update", (Object[])new Object[0]), (CvsOperation)new UpdateOperation(new FilePath[0], updateSettings, project), FileSetToBeUpdated.selectedFiles(files));
        this.myRoots = new ArrayList<VirtualFile>();
        this.myNotProcessedRepositories = new HashSet();
        this.myCorruptedFiles = new ArrayList<MergedWithConflictProjectOrModuleFile>();
        this.myFiles = files;
        this.myProject = project;
        this.myUpdatedFiles = updatedFiles;
        this.myUpdateSettings = updateSettings;
    }

    @Override
    public void beforeLogin() {
        try {
            super.beforeLogin();
            FindAllRoots findAllRoots = new FindAllRoots(this.myProject);
            FilePath[] filteredFiles = FindAllRootsHelper.findVersionedUnder(this.myFiles);
            this.myRoots.addAll(findAllRoots.executeOn(filteredFiles));
            this.myNotProcessedRepositories.addAll(findAllRoots.getDirectoriesToBeUpdated());
            this.myDirectoriesToBeProcessedCount = this.myNotProcessedRepositories.size();
            for (VirtualFile file : this.myRoots) {
                if (UpdateHandler.getValidCvsRoot(file) == null) continue;
                ((UpdateOperation)this.myCvsOperation).addFile(file);
            }
        }
        catch (ProcessCanceledException ex) {
            this.myIsCanceled = true;
        }
    }

    @Nullable
    private static CvsRootProvider getValidCvsRoot(VirtualFile file) {
        try {
            return CvsRootProvider.createOn(new File(file.getPath()));
        }
        catch (CannotFindCvsRootException e) {
            return null;
        }
    }

    @Override
    public void addFileMessage(String message, ICvsFileSystem cvsFileSystem) {
        super.addFileMessage(message, cvsFileSystem);
        ProgressIndicator progress = this.getProgress();
        if (progress == null) {
            return;
        }
        if (UPDATE_PATTERN.matches(message)) {
            String relativeFileName = UPDATE_PATTERN.getRelativeFileName(message);
            this.myNotProcessedRepositories.remove(cvsFileSystem.getLocalFileSystem().getFile(relativeFileName));
            int notProcessedSize = this.myNotProcessedRepositories.size();
            progress.setFraction(0.5 + (this.myDirectoriesToBeProcessedCount - (double)notProcessedSize) / (2.0 * this.myDirectoriesToBeProcessedCount));
        }
    }

    @Override
    public void registerCorruptedProjectOrModuleFile(MergedWithConflictProjectOrModuleFile mergedWithConflictProjectOrModuleFile) {
        this.myCorruptedFiles.add(mergedWithConflictProjectOrModuleFile);
    }

    @Override
    protected void onOperationFinished(ModalityContext modalityContext) {
        if (this.myUpdateSettings.getPruneEmptyDirectories()) {
            IOFilesBasedDirectoryPruner pruner = new IOFilesBasedDirectoryPruner(ProgressManager.getInstance().getProgressIndicator());
            for (VirtualFile myRoot : this.myRoots) {
                pruner.addFile(new File(myRoot.getPath()));
            }
            pruner.execute();
        }
        if (!this.myCorruptedFiles.isEmpty()) {
            int showOptions = CvsConfiguration.getInstance((Project)this.myProject).SHOW_CORRUPTED_PROJECT_FILES;
            if (showOptions == 1) {
                for (MergedWithConflictProjectOrModuleFile myCorruptedFile : this.myCorruptedFiles) {
                    myCorruptedFile.setShouldBeCheckedOut();
                }
            } else if (showOptions == 0) {
                modalityContext.runInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        new CorruptedProjectFilesDialog(UpdateHandler.this.myProject, UpdateHandler.this.myCorruptedFiles).show();
                    }
                }, this.myProject);
            }
            VcsKey vcsKey = CvsVcs2.getKey();
            for (MergedWithConflictProjectOrModuleFile myCorruptedFile : this.myCorruptedFiles) {
                if (myCorruptedFile.shouldBeCheckedOut()) {
                    this.addFileToCheckout(myCorruptedFile.getOriginal());
                    continue;
                }
                this.myUpdatedFiles.getGroupById("MODIFIED").add(myCorruptedFile.getOriginal().getPath(), vcsKey, null);
            }
        }
    }

    @Override
    protected PostCvsActivity getPostActivityHandler() {
        return this;
    }
}

