/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootOnEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootOnFileSystem;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.CvsRoot;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.IConnection;

public abstract class CvsRootProvider
implements CvsEnvironment {
    private File myLocalRoot;
    private File myAdminRoot;
    protected final CvsEnvironment myCvsEnvironment;

    public static CvsRootProvider createOn(File file) throws CannotFindCvsRootException {
        return CvsRootOnFileSystem.createMeOn(file);
    }

    public static CvsRootProvider createOn(File file, CvsEnvironment env) {
        return new CvsRootOnEnvironment(file, env);
    }

    public CvsRootProvider(File rootFile, CvsEnvironment cvsRoot) {
        this.myLocalRoot = rootFile;
        this.myAdminRoot = rootFile;
        this.myCvsEnvironment = cvsRoot;
    }

    public void changeLocalRootTo(@NotNull File localRoot) {
        if (localRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/connections/CvsRootProvider.changeLocalRootTo must not be null");
        }
        this.myLocalRoot = localRoot;
    }

    public IConnection createConnection(ReadWriteStatistics statistics) {
        return this.myCvsEnvironment.createConnection(statistics);
    }

    public CvsLoginWorker getLoginWorker(ModalityContext executor, Project project) {
        return this.myCvsEnvironment.getLoginWorker(executor, project);
    }

    public CvsRoot getCvsRoot() {
        return this.myCvsEnvironment.getCvsRoot();
    }

    public String getCvsRootAsString() {
        return this.myCvsEnvironment.getCvsRootAsString();
    }

    public File getLocalRoot() {
        return this.myLocalRoot;
    }

    public File getAdminRoot() {
        return this.myAdminRoot;
    }

    public void changeAdminRootTo(File directory) {
        this.myAdminRoot = directory;
    }

    public boolean isValid() {
        return this.myCvsEnvironment.isValid();
    }

    public CommandException processException(CommandException t) {
        return this.myCvsEnvironment.processException(t);
    }

    public boolean isOffline() {
        return this.myCvsEnvironment.isOffline();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CvsRootProvider)) {
            return false;
        }
        CvsRootProvider that = (CvsRootProvider)o;
        if (this.myAdminRoot != null ? !this.myAdminRoot.equals(that.myAdminRoot) : that.myAdminRoot != null) {
            return false;
        }
        if (this.myLocalRoot != null ? !this.myLocalRoot.equals(that.myLocalRoot) : that.myLocalRoot != null) {
            return false;
        }
        ThreeState checkEnv = this.checkNulls(this.myCvsEnvironment, that.myCvsEnvironment);
        if (!ThreeState.UNSURE.equals((Object)checkEnv)) {
            return ThreeState.YES.equals((Object)checkEnv);
        }
        ThreeState checkRoot = this.checkNulls(this.myCvsEnvironment.getCvsRoot(), that.myCvsEnvironment.getCvsRoot());
        if (!ThreeState.UNSURE.equals((Object)checkRoot)) {
            return ThreeState.YES.equals((Object)checkRoot);
        }
        if (this.myCvsEnvironment.getCvsRoot().getRepositoryPath() != null ? !this.myCvsEnvironment.getCvsRoot().getRepositoryPath().equals(that.myCvsEnvironment.getCvsRoot().getRepositoryPath()) : that.myCvsEnvironment.getCvsRoot().getRepositoryPath() != null) {
            return false;
        }
        return !(this.myCvsEnvironment.getCvsRoot().getCvsRoot() != null ? !this.myCvsEnvironment.getCvsRoot().getCvsRoot().equals(that.myCvsEnvironment.getCvsRoot().getCvsRoot()) : that.myCvsEnvironment.getCvsRoot().getCvsRoot() != null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private ThreeState checkNulls(Object one, Object two) {
        ThreeState threeState;
        if (one == null ^ two == null) {
            threeState = ThreeState.NO;
            if (threeState == null) throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/connections/CvsRootProvider.checkNulls must not return null");
            return threeState;
        }
        if (one == null) {
            threeState = ThreeState.YES;
            if (threeState == null) throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/connections/CvsRootProvider.checkNulls must not return null");
            return threeState;
        }
        threeState = ThreeState.UNSURE;
        if (threeState != null) return threeState;
        throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/connections/CvsRootProvider.checkNulls must not return null");
    }

    public int hashCode() {
        int result = this.myLocalRoot != null ? this.myLocalRoot.hashCode() : 0;
        result = 31 * result + (this.myAdminRoot != null ? this.myAdminRoot.hashCode() : 0);
        if (this.myCvsEnvironment != null && this.myCvsEnvironment.getCvsRoot() != null) {
            CvsRoot root = this.myCvsEnvironment.getCvsRoot();
            result = 31 * result + (root.getRepositoryPath() != null ? root.getRepositoryPath().hashCode() : 0);
            result = 31 * result + (root.getCvsRoot() != null ? root.getCvsRoot().hashCode() : 0);
        }
        return result;
    }
}

