/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.ActionOnSelectedElement;
import com.intellij.cvsSupport2.actions.AddFileOrDirectoryAction;
import com.intellij.cvsSupport2.actions.actionVisibility.CvsActionVisibility;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextAdapter;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.cvsSupport2.ui.Options;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IgnoreFileAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.actions.IgnoreFileAction");
    private final CvsActionVisibility myVisibility = new CvsActionVisibility();
    private final Map<VirtualFile, Set<VirtualFile>> myParentToSelectedChildren = new HashMap();

    public IgnoreFileAction() {
        this.myVisibility.canBePerformedOnSeveralFiles();
        this.myVisibility.addCondition(ActionOnSelectedElement.FILES_HAVE_PARENT_UNDER_CVS);
        this.myVisibility.addCondition(ActionOnSelectedElement.FILES_ARENT_UNDER_CVS);
        this.myVisibility.addCondition(ActionOnSelectedElement.FILES_ARE_NOT_IGNORED);
    }

    public void update(AnActionEvent e) {
        this.myVisibility.applyToEvent(e);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] selectedFiles;
        CvsContext context = CvsContextWrapper.createCachedInstance(e);
        for (VirtualFile selectedFile : selectedFiles = context.getSelectedFiles()) {
            VirtualFile parent = selectedFile.getParent();
            if (!this.myParentToSelectedChildren.containsKey(parent)) {
                this.myParentToSelectedChildren.put(parent, new HashSet());
            }
            this.myParentToSelectedChildren.get(parent).add(selectedFile);
            try {
                CvsUtil.ignoreFile(selectedFile);
            }
            catch (IOException e1) {
                Messages.showErrorDialog((String)CvsBundle.message((String)"message.error.ignore.files", (Object[])new Object[]{selectedFile.getPresentableUrl(), e1.getLocalizedMessage()}), (String)CvsBundle.message((String)"message.error.ignore.files.title", (Object[])new Object[0]));
            }
        }
        this.refreshFilesAndStatuses(context);
    }

    private static void refreshPanel(CvsContext context) {
        Refreshable refreshablePanel = context.getRefreshableDialog();
        if (refreshablePanel != null) {
            refreshablePanel.restoreState();
            refreshablePanel.refresh();
        }
    }

    private void refreshFilesAndStatuses(CvsContext context) {
        Refreshable refreshablePanel = context.getRefreshableDialog();
        if (refreshablePanel != null) {
            refreshablePanel.saveState();
        }
        int[] refreshedParents = new int[]{0};
        ArrayList<VirtualFile> createdCvsIgnoreFiles = new ArrayList<VirtualFile>();
        for (VirtualFile parent : this.myParentToSelectedChildren.keySet()) {
            parent.refresh(true, true, this.parentPostRefreshAction(refreshedParents, createdCvsIgnoreFiles, context, parent));
        }
    }

    private Runnable parentPostRefreshAction(final int[] refreshedParents, final Collection<VirtualFile> createdCvsIgnoreFiles, final CvsContext context, final VirtualFile parent) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    VirtualFile cvsIgnoreFile = CvsVfsUtil.refreshAndfFindChild(parent, ".cvsignore");
                    if (cvsIgnoreFile == null) {
                        String path = parent.getPath() + "/" + ".cvsignore";
                        LOG.error(String.valueOf(CvsVfsUtil.findFileByPath(path)) + " " + parent.getPath() + " " + new File(VfsUtil.virtualToIoFile((VirtualFile)parent), ".cvsignore").isFile());
                        return;
                    }
                    if (!CvsUtil.fileIsUnderCvs(cvsIgnoreFile)) {
                        createdCvsIgnoreFiles.add(cvsIgnoreFile);
                    }
                    Set filesToUpdateStatus = (Set)IgnoreFileAction.this.myParentToSelectedChildren.get(parent);
                    for (VirtualFile file : filesToUpdateStatus) {
                        FileStatusManager.getInstance((Project)context.getProject()).fileStatusChanged(file);
                        VcsDirtyScopeManager.getInstance((Project)context.getProject()).fileDirty(file);
                    }
                }
                finally {
                    refreshedParents[0] = refreshedParents[0] + 1;
                    if (IgnoreFileAction.this.allParentsWasRefreshed(refreshedParents)) {
                        if (createdCvsIgnoreFiles.isEmpty()) {
                            IgnoreFileAction.refreshPanel(context);
                        } else {
                            this.addCvsIgnoreFilesToCvsAndRefreshPanel();
                        }
                    }
                }
            }

            private void addCvsIgnoreFilesToCvsAndRefreshPanel() {
                this.createAddFilesAction().actionPerformed(IgnoreFileAction.createContext(createdCvsIgnoreFiles, context));
            }

            private AddFileOrDirectoryAction createAddFilesAction() {
                return new AddFileOrDirectoryAction(CvsBundle.message((String)"adding.cvsignore.files.to.cvs.action.name", (Object[])new Object[0]), Options.ON_FILE_ADDING, true){

                    @Override
                    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
                        IgnoreFileAction.refreshPanel(context);
                    }
                };
            }
        };
    }

    private static CvsContextAdapter createContext(final Collection<VirtualFile> createdCvsIgnoreFiles, final CvsContext context) {
        return new CvsContextAdapter(){

            @Override
            public VirtualFile[] getSelectedFiles() {
                return VfsUtil.toVirtualFileArray((Collection)createdCvsIgnoreFiles);
            }

            @Override
            public Refreshable getRefreshableDialog() {
                return context.getRefreshableDialog();
            }

            @Override
            public Project getProject() {
                return context.getProject();
            }
        };
    }

    private boolean allParentsWasRefreshed(int[] refreshedParents) {
        return refreshedParents[0] == this.myParentToSelectedChildren.size();
    }
}

