/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.structureView.impl.StructureNodeRenderer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class MethodListDlg
extends DialogWrapper {
    private final PsiClass myClass;
    private static final Comparator<PsiMethod> METHOD_NAME_COMPARATOR = new Comparator<PsiMethod>(){

        @Override
        public int compare(PsiMethod psiMethod, PsiMethod psiMethod1) {
            return psiMethod.getName().compareToIgnoreCase(psiMethod1.getName());
        }
    };
    private final SortedListModel<PsiMethod> myListModel = new SortedListModel(METHOD_NAME_COMPARATOR);
    private final JList myList = new JList<PsiMethod>((ListModel<PsiMethod>)this.myListModel);
    private final JPanel myWholePanel = new JPanel(new BorderLayout());

    public MethodListDlg(PsiClass psiClass, Condition<PsiMethod> filter, JComponent parent) {
        super((Component)parent, false);
        this.myClass = psiClass;
        this.createList(psiClass.getAllMethods(), filter);
        this.myWholePanel.add(ScrollPaneFactory.createScrollPane((JComponent)this.myList));
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                PsiMethod psiMethod = (PsiMethod)value;
                this.append(PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)0), StructureNodeRenderer.applyDeprecation((Object)psiMethod, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                PsiClass containingClass = psiMethod.getContainingClass();
                if (!MethodListDlg.this.myClass.equals(containingClass)) {
                    this.append(" (" + containingClass.getQualifiedName() + ")", StructureNodeRenderer.applyDeprecation((Object)containingClass, (SimpleTextAttributes)SimpleTextAttributes.GRAY_ATTRIBUTES));
                }
            }
        });
        this.myList.setSelectionMode(0);
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MethodListDlg.this.close(0);
                    e.consume();
                }
            }
        });
        ListScrollingUtil.ensureSelectionExists((JList)this.myList);
        this.setTitle(ExecutionBundle.message((String)"choose.test.method.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    private void createList(PsiMethod[] allMethods, Condition<PsiMethod> filter) {
        for (int i = 0; i < allMethods.length; ++i) {
            PsiMethod method = allMethods[i];
            if (!filter.value((Object)method)) continue;
            this.myListModel.add((Object)method);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myWholePanel;
    }

    public PsiMethod getSelected() {
        return (PsiMethod)this.myList.getSelectedValue();
    }
}

