/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.TestUtil;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class TestClassFilter
implements TreeClassChooser.ClassFilterWithScope {
    private final PsiClass myBase;
    private final Project myProject;
    private final GlobalSearchScope myScope;

    private TestClassFilter(@NotNull PsiClass base, GlobalSearchScope scope) {
        if (base == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit/TestClassFilter.<init> must not be null");
        }
        this.myBase = base;
        this.myProject = base.getProject();
        this.myScope = scope;
    }

    public PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAccepted(PsiClass aClass) {
        return ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS.value((Object)aClass) && (aClass.isInheritor(this.myBase, true) || TestUtil.isTestClass((PsiClass)aClass)) && !CompilerConfiguration.getInstance((Project)this.getProject()).isExcludedFromCompilation(PsiUtilBase.getVirtualFile((PsiElement)aClass));
    }

    public TestClassFilter intersectionWith(GlobalSearchScope scope) {
        return new TestClassFilter(this.myBase, this.myScope.intersectWith(scope));
    }

    public static TestClassFilter create(SourceScope sourceScope, Module module) throws JUnitUtil.NoJUnitException {
        if (sourceScope == null) {
            throw new JUnitUtil.NoJUnitException();
        }
        PsiClass testCase = module == null ? JUnitUtil.getTestCaseClass((SourceScope)sourceScope) : JUnitUtil.getTestCaseClass((Module)module);
        return new TestClassFilter(testCase, sourceScope.getGlobalSearchScope());
    }

    public GlobalSearchScope getScope() {
        return this.myScope;
    }

    public PsiClass getBase() {
        return this.myBase;
    }
}

