/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.GitFileUtils;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitVFSListener
extends VcsVFSListener {
    public GitVFSListener(Project project, GitVcs vcs) {
        super(project, (AbstractVcs)vcs);
    }

    protected String getAddTitle() {
        return GitBundle.getString("vfs.listener.add.title");
    }

    protected String getSingleFileAddTitle() {
        return GitBundle.getString("vfs.listener.add.single.title");
    }

    protected String getSingleFileAddPromptTemplate() {
        return GitBundle.getString("vfs.listener.add.single.prompt");
    }

    protected void performAdding(Collection<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copyFromMap) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(addedFiles, true);
        }
        catch (VcsException e) {
            this.gitVcs().showMessages(e.getMessage());
            return;
        }
        this.gitVcs().runInBackground(new Task.Backgroundable(this.myProject, GitBundle.getString("add.adding")){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/vfs/GitVFSListener$1.run must not be null");
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    try {
                        VirtualFile root = (VirtualFile)e.getKey();
                        indicator.setText(root.getPresentableUrl());
                        GitFileUtils.addFiles(this.myProject, root, (Collection)e.getValue());
                        GitUtil.markFilesDirty(this.myProject, (Collection)e.getValue());
                    }
                    catch (VcsException ex) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GitVFSListener.this.gitVcs().showMessages(ex.getMessage());
                            }
                        });
                    }
                }
            }
        });
    }

    private GitVcs gitVcs() {
        return (GitVcs)this.myVcs;
    }

    private void performAdding(Collection<FilePath> addedFiles) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(addedFiles, true);
        }
        catch (VcsException e) {
            this.gitVcs().showMessages(e.getMessage());
            return;
        }
        this.gitVcs().runInBackground(new Task.Backgroundable(this.myProject, GitBundle.getString("add.adding")){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/vfs/GitVFSListener$2.run must not be null");
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    try {
                        VirtualFile root = (VirtualFile)e.getKey();
                        indicator.setText(root.getPresentableUrl());
                        GitFileUtils.addPaths(this.myProject, root, (Collection)e.getValue());
                        GitUtil.markFilesDirty(this.myProject, (List)e.getValue());
                    }
                    catch (VcsException ex) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GitVFSListener.this.gitVcs().showMessages(ex.getMessage());
                            }
                        });
                    }
                }
            }
        });
    }

    protected String getDeleteTitle() {
        return GitBundle.getString("vfs.listener.delete.title");
    }

    protected String getSingleFileDeleteTitle() {
        return GitBundle.getString("vfs.listener.delete.single.title");
    }

    protected String getSingleFileDeletePromptTemplate() {
        return GitBundle.getString("vfs.listener.delete.single.prompt");
    }

    protected void performDeletion(List<FilePath> filesToDelete) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(filesToDelete, true);
        }
        catch (VcsException e) {
            this.gitVcs().showMessages(e.getMessage());
            return;
        }
        this.gitVcs().runInBackground(new Task.Backgroundable(this.myProject, GitBundle.getString("remove.removing")){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/vfs/GitVFSListener$3.run must not be null");
                }
                HashSet<File> filesToRefresh = new HashSet<File>();
                for (Map.Entry e : sortedFiles.entrySet()) {
                    try {
                        VirtualFile root = (VirtualFile)e.getKey();
                        File rootFile = new File(root.getPath());
                        indicator.setText(root.getPresentableUrl());
                        GitFileUtils.delete(this.myProject, root, (Collection)e.getValue(), "--ignore-unmatch");
                        GitUtil.markFilesDirty(this.myProject, (List)e.getValue());
                        for (FilePath p : (List)e.getValue()) {
                            for (File f = p.getIOFile(); f != null && !f.equals(rootFile); f = f.getParentFile()) {
                                filesToRefresh.add(f);
                            }
                        }
                    }
                    catch (VcsException ex) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GitVFSListener.this.gitVcs().showMessages(ex.getMessage());
                            }
                        });
                    }
                }
                LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh);
            }
        });
    }

    protected void performMoveRename(List<VcsVFSListener.MovedFileInfo> movedFiles) {
        ArrayList<FilePath> added = new ArrayList<FilePath>();
        ArrayList<FilePath> removed = new ArrayList<FilePath>();
        for (VcsVFSListener.MovedFileInfo m : movedFiles) {
            added.add(VcsUtil.getFilePath((String)m.myNewPath));
            removed.add(VcsUtil.getFilePath((String)m.myOldPath));
        }
        this.performAdding(added);
        this.performDeletion(removed);
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    protected Collection<FilePath> selectFilePathsToDelete(List<FilePath> deletedFiles) {
        return deletedFiles;
    }
}

