/*
 * Decompiled with CFR 0.152.
 */
package git4idea.diff;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitDiffProvider
implements DiffProvider {
    private final Project myProject;
    private final FileStatusManager myStatusManager;
    private static final Set<FileStatus> ourGoodStatuses = new THashSet();

    public GitDiffProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/diff/GitDiffProvider.<init> must not be null");
        }
        this.myProject = project;
        this.myStatusManager = FileStatusManager.getInstance((Project)this.myProject);
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(VirtualFile file) {
        if (file.isDirectory()) {
            return null;
        }
        try {
            return GitHistoryUtils.getCurrentRevision(this.myProject, VcsUtil.getFilePath((String)file.getPath()));
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public ItemLatestState getLastRevision(VirtualFile file) {
        if (file.isDirectory()) {
            return null;
        }
        if (!ourGoodStatuses.contains(this.myStatusManager.getStatus(file))) {
            return null;
        }
        try {
            return GitHistoryUtils.getLastRevision(this.myProject, VcsUtil.getFilePath((String)file.getPath()));
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public ContentRevision createFileContent(VcsRevisionNumber revisionNumber, VirtualFile selectedFile) {
        if (selectedFile.isDirectory()) {
            return null;
        }
        String path = selectedFile.getPath();
        if (GitUtil.gitRootOrNull(selectedFile) == null) {
            return null;
        }
        try {
            FilePath filePath = VcsUtil.getFilePath((String)path);
            for (VcsFileRevision f : GitHistoryUtils.history(this.myProject, filePath)) {
                GitFileRevision gitRevision = (GitFileRevision)f;
                if (!f.getRevisionNumber().equals(revisionNumber)) continue;
                return new GitContentRevision(gitRevision.getPath(), (GitRevisionNumber)revisionNumber, this.myProject, selectedFile.getCharset());
            }
            GitContentRevision candidate = new GitContentRevision(filePath, (GitRevisionNumber)revisionNumber, this.myProject, selectedFile.getCharset());
            try {
                candidate.getContent();
                return candidate;
            }
            catch (VcsException e) {
            }
        }
        catch (VcsException e) {
            GitVcs.getInstance(this.myProject).showErrors(Collections.singletonList(e), GitBundle.message("diff.find.error", path));
        }
        return null;
    }

    public ItemLatestState getLastRevision(FilePath filePath) {
        if (filePath.isDirectory()) {
            return null;
        }
        VirtualFile vf = filePath.getVirtualFile();
        if (vf != null && !ourGoodStatuses.contains(this.myStatusManager.getStatus(vf))) {
            return null;
        }
        try {
            return GitHistoryUtils.getLastRevision(this.myProject, filePath);
        }
        catch (VcsException e) {
            return null;
        }
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }

    static {
        ourGoodStatuses.addAll(Arrays.asList(FileStatus.NOT_CHANGED, FileStatus.DELETED, FileStatus.MODIFIED, FileStatus.MERGE, FileStatus.MERGED_WITH_CONFLICTS));
    }
}

