/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Processor;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitSSHGUIHandler;
import git4idea.commands.GitSSHIdeaService;
import git4idea.config.GitVcsSettings;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.ssh.GitSSHService;

public abstract class GitHandler {
    private final HashSet<Integer> myIgnoredErrorCodes;
    private final List<VcsException> myErrors;
    private static final Logger log = Logger.getInstance((String)GitHandler.class.getName());
    private final GeneralCommandLine myCommandLine;
    private OSProcessHandler myHandler;
    private Process myProcess;
    private boolean myStdoutSuppressed;
    private boolean myStderrSuppressed;
    private final Project myProject;
    protected final GitCommand myCommand;
    private final File myWorkingDirectory;
    private boolean myEnvironmentCleanedUp;
    private int myHandlerNo;
    private Processor<OutputStream> myInputProcessor;
    private boolean myIsCancellable;
    private Integer myExitCode;
    @NonNls
    private Charset myCharset;
    private boolean myNoSSHFlag;
    private final EventDispatcher<GitHandlerListener> myListeners;
    private boolean mySilent;
    protected final GitVcs myVcs;
    private final Map<String, String> myEnv;
    private GitVcsSettings mySettings;
    private Runnable mySuspendAction;
    private Runnable myResumeAction;

    protected GitHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        String home;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitHandler.<init> must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/commands/GitHandler.<init> must not be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/commands/GitHandler.<init> must not be null");
        }
        this.myIgnoredErrorCodes = new HashSet();
        this.myErrors = Collections.synchronizedList(new LinkedList());
        this.myEnvironmentCleanedUp = true;
        this.myIsCancellable = true;
        this.myCharset = Charset.forName("UTF-8");
        this.myNoSSHFlag = false;
        this.myListeners = EventDispatcher.create(GitHandlerListener.class);
        this.myProject = project;
        this.myCommand = command;
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myEnv = new HashMap<String, String>(System.getenv());
        if (!this.myEnv.containsKey("HOME") && (home = System.getProperty("user.home")) != null) {
            this.myEnv.put("HOME", home);
        }
        this.myVcs = GitVcs.getInstance(project);
        if (this.myVcs != null) {
            this.myVcs.checkVersion();
        }
        this.myWorkingDirectory = directory;
        this.myCommandLine = new GeneralCommandLine();
        this.myCommandLine.setExePath(this.mySettings.getGitExecutable());
        this.myCommandLine.setWorkingDirectory(this.myWorkingDirectory);
        if (command.name().length() > 0) {
            this.myCommandLine.addParameter(command.name());
        }
    }

    protected GitHandler(Project project, VirtualFile vcsRoot, GitCommand command) {
        this(project, VfsUtil.virtualToIoFile((VirtualFile)vcsRoot), command);
    }

    public void ignoreErrorCode(int code) {
        this.myIgnoredErrorCodes.add(code);
    }

    public boolean isIgnoredErrorCode(int code) {
        return this.myIgnoredErrorCodes.contains(code);
    }

    public void addError(VcsException ex) {
        this.myErrors.add(ex);
    }

    public List<VcsException> errors() {
        return Collections.unmodifiableList(this.myErrors);
    }

    public Project project() {
        return this.myProject;
    }

    public File workingDirectory() {
        return this.myWorkingDirectory;
    }

    public VirtualFile workingDirectoryFile() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(this.workingDirectory());
        if (file == null) {
            throw new IllegalStateException("The working directly should be available: " + this.workingDirectory());
        }
        return file;
    }

    public void setNoSSH(boolean value) {
        this.checkNotStarted();
        this.myNoSSHFlag = value;
    }

    public boolean isNoSSH() {
        return this.myNoSSHFlag;
    }

    protected void addListener(GitHandlerListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void endOptions() {
        this.myCommandLine.addParameter("--");
    }

    public void addParameters(String ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitHandler.addParameters must not be null");
        }
        this.checkNotStarted();
        this.myCommandLine.addParameters(parameters);
    }

    public void addParameters(List<String> parameters) {
        this.checkNotStarted();
        this.myCommandLine.addParameters(parameters);
    }

    public void addRelativePaths(FilePath ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitHandler.addRelativePaths must not be null");
        }
        this.addRelativePaths(Arrays.asList(parameters));
    }

    public void addRelativePaths(@NotNull Collection<FilePath> filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitHandler.addRelativePaths must not be null");
        }
        this.checkNotStarted();
        for (FilePath path : filePaths) {
            this.myCommandLine.addParameter(GitUtil.relativePath(this.myWorkingDirectory, path));
        }
    }

    public void addRelativePathsForFiles(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitHandler.addRelativePathsForFiles must not be null");
        }
        this.checkNotStarted();
        for (File file : files) {
            this.myCommandLine.addParameter(GitUtil.relativePath(this.myWorkingDirectory, file));
        }
    }

    public void addRelativeFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/commands/GitHandler.addRelativeFiles must not be null");
        }
        this.checkNotStarted();
        for (VirtualFile file : files) {
            this.myCommandLine.addParameter(GitUtil.relativePath(this.myWorkingDirectory, file));
        }
    }

    private void checkNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("The process has been already started");
        }
    }

    protected final void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("The process is not started yet");
        }
    }

    public final synchronized boolean isStarted() {
        return this.myProcess != null;
    }

    public void setCancellable(boolean value) {
        this.checkNotStarted();
        this.myIsCancellable = value;
    }

    public boolean isCancellable() {
        return this.myIsCancellable;
    }

    public synchronized void start() {
        this.checkNotStarted();
        try {
            if (!this.myProject.isDefault() && !this.mySilent) {
                this.myVcs.showCommandLine("cd " + this.myWorkingDirectory);
                this.myVcs.showCommandLine(this.printableCommandLine());
            }
            if (log.isDebugEnabled()) {
                log.debug("running git: " + this.myCommandLine.getCommandLineString() + " in " + this.myWorkingDirectory);
            }
            if (!this.myNoSSHFlag && this.mySettings.isIdeaSsh()) {
                GitSSHIdeaService ssh = GitSSHIdeaService.getInstance();
                this.myEnv.put("GIT_SSH", ssh.getScriptPath().getPath());
                this.myHandlerNo = ssh.registerHandler(new GitSSHGUIHandler(this.myProject));
                this.myEnvironmentCleanedUp = false;
                this.myEnv.put("GIT4IDEA_SSH_HANDLER", Integer.toString(this.myHandlerNo));
                this.myEnv.put("GIT4IDEA_SSH_PORT", Integer.toString(((GitSSHService)ssh).getXmlRcpPort()));
            }
            this.myCommandLine.setEnvParams(this.myEnv);
            this.myProcess = this.myCommandLine.createProcess();
            this.myHandler = new OSProcessHandler(this.myProcess, this.myCommandLine.getCommandLineString()){

                public Charset getCharset() {
                    return GitHandler.this.myCharset == null ? super.getCharset() : GitHandler.this.myCharset;
                }
            };
            this.myHandler.addProcessListener(new ProcessListener(){

                public void startNotified(ProcessEvent event) {
                }

                public void processTerminated(ProcessEvent event) {
                    int exitCode = event.getExitCode();
                    GitHandler.this.setExitCode(exitCode);
                    GitHandler.this.cleanupEnv();
                    GitHandler.this.processTerminated(exitCode);
                    ((GitHandlerListener)GitHandler.this.myListeners.getMulticaster()).processTerminated(exitCode);
                }

                public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                }

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    GitHandler.this.onTextAvailable(event.getText(), outputType);
                }
            });
            this.myHandler.startNotify();
        }
        catch (Throwable t) {
            this.cleanupEnv();
            ((GitHandlerListener)this.myListeners.getMulticaster()).startFailed(t);
        }
    }

    protected abstract void processTerminated(int var1);

    public String printableCommandLine() {
        GeneralCommandLine line = this.myCommandLine.clone();
        line.setExePath("git");
        return line.getCommandLineString();
    }

    protected abstract void onTextAvailable(String var1, Key var2);

    public synchronized void cancel() {
        this.checkStarted();
        if (!this.myIsCancellable) {
            throw new IllegalStateException("The process is not cancellable.");
        }
        try {
            this.myHandler.destroyProcess();
        }
        catch (Exception e) {
            log.warn("Exception during cancel", (Throwable)e);
        }
    }

    public synchronized int getExitCode() {
        if (this.myExitCode == null) {
            throw new IllegalStateException("Exit code is not yet available");
        }
        return this.myExitCode;
    }

    private synchronized void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    private synchronized void cleanupEnv() {
        if (!this.myNoSSHFlag && !this.myEnvironmentCleanedUp) {
            GitSSHIdeaService ssh = GitSSHIdeaService.getInstance();
            this.myEnvironmentCleanedUp = true;
            ssh.unregisterHandler(this.myHandlerNo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        this.checkStarted();
        try {
            if (this.myInputProcessor != null) {
                this.myInputProcessor.process((Object)this.myHandler.getProcessInput());
            }
        }
        finally {
            this.myHandler.waitFor();
        }
    }

    public void setSilent(boolean silent) {
        this.checkNotStarted();
        this.mySilent = silent;
        this.setStderrSuppressed(true);
        this.setStdoutSuppressed(true);
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public boolean isStdoutSuppressed() {
        return this.myStdoutSuppressed;
    }

    public void setStdoutSuppressed(boolean stdoutSuppressed) {
        this.checkNotStarted();
        this.myStdoutSuppressed = stdoutSuppressed;
    }

    public boolean isStderrSuppressed() {
        return this.myStderrSuppressed;
    }

    public void setStderrSuppressed(boolean stderrSuppressed) {
        this.checkNotStarted();
        this.myStderrSuppressed = stderrSuppressed;
    }

    public void setEnvironment(String name, String value) {
        this.myEnv.put(name, value);
    }

    public void setInputProcessor(Processor<OutputStream> inputProcessor) {
        this.myInputProcessor = inputProcessor;
    }

    synchronized void setSuspendResume(Runnable suspend, Runnable resume) {
        this.mySuspendAction = suspend;
        this.myResumeAction = resume;
    }

    public synchronized void suspendWriteLock() {
        assert (this.mySuspendAction != null);
        this.mySuspendAction.run();
    }

    public synchronized void resumeWriteLock() {
        assert (this.mySuspendAction != null);
        this.myResumeAction.run();
    }

    public boolean isLargeCommandLine() {
        return this.myCommandLine.getCommandLineString().length() > 7600;
    }
}

