/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.OutgoingChangesUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TestOutgoingAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        VcsOutgoingChangesProvider provider = vcs.getOutgoingChangesProvider();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VirtualFile vf = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        try {
            if (vf != null) {
                VirtualFile root = vcsManager.getVcsRootFor(vf);
                Pair revisionNumberListPair = provider.getOutgoingChanges(root, true);
                VcsRevisionNumber revisionNumber = provider.getMergeBaseNumber(vf);
                System.out.println("revisionNumber = " + revisionNumber);
                CurrentContentRevision contentRevision = new CurrentContentRevision((FilePath)new FilePathImpl(vf));
                Collection rootsForChanges = OutgoingChangesUtil.getVcsRootsForChanges((AbstractVcs)vcs, Collections.singletonList(new Change((ContentRevision)contentRevision, (ContentRevision)contentRevision)));
            }
        }
        catch (VcsException e1) {
            e1.printStackTrace();
        }
        VirtualFile[] roots = vcsManager.getRootsUnderVcs((AbstractVcs)vcs);
        if (roots == null) {
            return;
        }
        for (VirtualFile root : roots) {
            try {
                Pair pair = provider.getOutgoingChanges(root, true);
                VcsRevisionNumber number = provider.getMergeBaseNumber(root);
                System.out.println("list.size() = " + ((List)pair.getSecond()).size() + " number = " + number);
                if ($assertionsDisabled || number.equals(pair.getFirst())) continue;
                throw new AssertionError();
            }
            catch (VcsException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setText("Test Outgoing Changes");
    }
}

