/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class GitRepositoryAction
extends DumbAwareAction {
    final LinkedList<TransactionRunnable> myDelayedTasks = new LinkedList();

    public void actionPerformed(AnActionEvent e) {
        this.myDelayedTasks.clear();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        DataContext dataContext = e.getDataContext();
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        VirtualFile[] contentRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        if (contentRoots == null || contentRoots.length == 0) {
            Messages.showErrorDialog((Project)project, (String)GitBundle.getString("repository.action.missing.roots.unconfigured.message"), (String)GitBundle.getString("repository.action.missing.roots.title"));
            return;
        }
        final ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(GitUtil.gitRootsForPaths(Arrays.asList(contentRoots)));
        if (roots.size() == 0) {
            Messages.showErrorDialog((Project)project, (String)GitBundle.getString("repository.action.missing.roots.misconfigured"), (String)GitBundle.getString("repository.action.missing.roots.title"));
            return;
        }
        Collections.sort(roots, GitUtil.VIRTUAL_FILE_COMPARATOR);
        VirtualFile[] vFiles = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        VirtualFile defaultRootVar = null;
        if (vFiles != null) {
            for (VirtualFile file : vFiles) {
                VirtualFile root = GitUtil.gitRootOrNull(file);
                if (root == null) continue;
                defaultRootVar = root;
                break;
            }
        }
        if (defaultRootVar == null) {
            defaultRootVar = (VirtualFile)roots.get(0);
        }
        final VirtualFile defaultRoot = defaultRootVar;
        final HashSet affectedRoots = new HashSet();
        String actionName = this.getActionName();
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
        List exceptions = helper.runTransactionRunnable((AbstractVcs)vcs, new TransactionRunnable(){

            public void run(List<VcsException> exceptions) {
                try {
                    GitRepositoryAction.this.perform(project, roots, defaultRoot, affectedRoots, exceptions);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
                GitUtil.refreshFiles(project, affectedRoots);
                for (TransactionRunnable task : GitRepositoryAction.this.myDelayedTasks) {
                    task.run(exceptions);
                }
            }
        }, null);
        this.myDelayedTasks.clear();
        vcs.showErrors(exceptions, actionName);
    }

    public final void delayTask(@NotNull TransactionRunnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitRepositoryAction.delayTask must not be null");
        }
        this.myDelayedTasks.add(task);
    }

    @NotNull
    protected abstract String getActionName();

    protected abstract void perform(@NotNull Project var1, @NotNull List<VirtualFile> var2, @NotNull VirtualFile var3, Set<VirtualFile> var4, List<VcsException> var5) throws VcsException;

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        if (roots == null || roots.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        presentation.setEnabled(true);
        presentation.setVisible(true);
    }
}

