/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitRevisionNumber
implements VcsRevisionNumber {
    @NonNls
    public static final String TIP = "HEAD";
    public static final String NOT_COMMITTED_HASH;
    @NotNull
    private final String myRevisionHash;
    @NotNull
    private final Date myTimestamp;

    public GitRevisionNumber() {
        this.myRevisionHash = TIP;
        this.myTimestamp = new Date();
    }

    public GitRevisionNumber(@NonNls @NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitRevisionNumber.<init> must not be null");
        }
        this.myRevisionHash = version;
        this.myTimestamp = new Date();
    }

    public GitRevisionNumber(@NotNull String version, @NotNull Date timeStamp) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitRevisionNumber.<init> must not be null");
        }
        if (timeStamp == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitRevisionNumber.<init> must not be null");
        }
        this.myTimestamp = timeStamp;
        this.myRevisionHash = version;
    }

    @NotNull
    public String asString() {
        String string = this.myRevisionHash;
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitRevisionNumber.asString must not return null");
        }
        return string;
    }

    @NotNull
    public Date getTimestamp() {
        Date date = this.myTimestamp;
        if (date == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitRevisionNumber.getTimestamp must not return null");
        }
        return date;
    }

    @NotNull
    public String getRev() {
        String string = this.myRevisionHash;
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitRevisionNumber.getRev must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getShortRev() {
        String string;
        if (this.myRevisionHash.length() == 0) {
            return "";
        }
        if (this.myRevisionHash.length() == 40) {
            String string2 = this.myRevisionHash.substring(0, 8);
            string = string2;
            if (string2 == null) throw new IllegalStateException("@NotNull method git4idea/GitRevisionNumber.getShortRev must not return null");
            return string;
        }
        if (this.myRevisionHash.length() > 40) {
            String string3 = this.myRevisionHash.substring(this.myRevisionHash.indexOf("[") + 1, 8);
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method git4idea/GitRevisionNumber.getShortRev must not return null");
            return string;
        }
        String string4 = this.myRevisionHash;
        string = string4;
        if (string4 == null) throw new IllegalStateException("@NotNull method git4idea/GitRevisionNumber.getShortRev must not return null");
        return string;
    }

    public int compareTo(VcsRevisionNumber crev) {
        if (this == crev) {
            return 0;
        }
        if (crev instanceof GitRevisionNumber) {
            int tildeIndex;
            GitRevisionNumber other = (GitRevisionNumber)crev;
            if (other.myRevisionHash != null && this.myRevisionHash.equals(other.myRevisionHash)) {
                return 0;
            }
            if (other.myRevisionHash.indexOf("[") > 0 && other.myTimestamp != null) {
                return this.myTimestamp.compareTo(other.myTimestamp);
            }
            String otherName = null;
            String thisName = null;
            int otherParents = -1;
            int thisParent = -1;
            if (other.myRevisionHash.contains("~")) {
                tildeIndex = other.myRevisionHash.indexOf(126);
                otherName = other.myRevisionHash.substring(0, tildeIndex);
                otherParents = Integer.parseInt(other.myRevisionHash.substring(tildeIndex));
            }
            if (this.myRevisionHash.contains("~")) {
                tildeIndex = this.myRevisionHash.indexOf(126);
                thisName = this.myRevisionHash.substring(0, tildeIndex);
                thisParent = Integer.parseInt(this.myRevisionHash.substring(tildeIndex));
            }
            if (otherName == null && thisName == null) {
                int result = this.myTimestamp.compareTo(other.myTimestamp);
                if (result == 0) {
                    return this.myRevisionHash.compareTo(other.myRevisionHash);
                }
                return result;
            }
            if (otherName == null) {
                return 1;
            }
            if (thisName == null) {
                return -1;
            }
            return thisParent - otherParents;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitRevisionNumber test = (GitRevisionNumber)obj;
        return this.myRevisionHash.equals(test.myRevisionHash);
    }

    public int hashCode() {
        return this.myRevisionHash.hashCode();
    }

    public String getParentRevisionStr() {
        int tildeIndex;
        String rev = this.myRevisionHash;
        int bracketIdx = rev.indexOf("[");
        if (bracketIdx > 0) {
            rev = this.myRevisionHash.substring(bracketIdx + 1, this.myRevisionHash.indexOf("]"));
        }
        if ((tildeIndex = rev.indexOf("~")) > 0) {
            int n = Integer.parseInt(rev.substring(tildeIndex)) + 1;
            return rev.substring(0, tildeIndex) + "~" + n;
        }
        return rev + "~1";
    }

    public static GitRevisionNumber createRevision(String rev) {
        return new GitRevisionNumber(rev);
    }

    public static GitRevisionNumber resolve(Project project, VirtualFile vcsRoot, @NonNls String rev) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, vcsRoot, GitCommand.REV_LIST);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters("--timestamp", "--max-count=1", rev);
        h.endOptions();
        StringTokenizer tokenizer = new StringTokenizer(h.run(), "\n\r \t", false);
        Date timestamp = GitUtil.parseTimestamp(tokenizer.nextToken());
        return new GitRevisionNumber(tokenizer.nextToken(), timestamp);
    }

    public String toString() {
        return this.myRevisionHash;
    }

    static {
        char[] data = new char[40];
        Arrays.fill(data, '0');
        NOT_COMMITTED_HASH = new String(data);
    }
}

