/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.testng.ClassMethodMap;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.IMethodSelector;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Attributes;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.Constants;
import org.testng.internal.DynamicGraph;
import org.testng.internal.IConfigurationListener;
import org.testng.internal.IInvoker;
import org.testng.internal.IMethodWorker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.IWorkerFactory;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MapList;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.ResultMap;
import org.testng.internal.RunInfo;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IListeners;
import org.testng.internal.annotations.Sets;
import org.testng.internal.thread.GroupThreadPoolExecutor;
import org.testng.internal.thread.ThreadUtil;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner
implements ITestContext,
ITestResultNotifier,
IWorkerFactory {
    private static final long serialVersionUID = 4247820024988306670L;
    private ISuite m_suite;
    protected XmlTest m_xmlTest;
    private String m_testName;
    private transient List<XmlClass> m_testClassesFromXml = null;
    private transient List<XmlPackage> m_packageNamesFromXml = null;
    private transient IInvoker m_invoker = null;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient List<ITestListener> m_testListeners = Lists.newArrayList();
    private transient List<IConfigurationListener> m_configurationListeners = Lists.newArrayList();
    private transient IConfigurationListener m_confListener = new ConfigurationListener();
    private transient boolean m_skipFailedInvocationCounts;
    private ITestNGMethod[] m_allTestMethods = new ITestNGMethod[0];
    private Date m_startDate = null;
    private Date m_endDate = null;
    private transient Map<Class<?>, ITestClass> m_classMap = Maps.newHashMap();
    private String m_outputDirectory = Constants.getDefaultValueFor("testng.outputDir");
    private XmlMethodSelector m_xmlMethodSelector = new XmlMethodSelector();
    private static int m_verbose = 1;
    private ITestNGMethod[] m_beforeSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeXmlTestMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterXmlTestMethods = new ITestNGMethod[0];
    private List<ITestNGMethod> m_excludedMethods = Lists.newArrayList();
    private ConfigurationGroupMethods m_groupMethods = null;
    private Map<String, List<String>> m_metaGroups = Maps.newHashMap();
    private IResultMap m_passedTests = new ResultMap();
    private IResultMap m_failedTests = new ResultMap();
    private IResultMap m_failedButWithinSuccessPercentageTests = new ResultMap();
    private IResultMap m_skippedTests = new ResultMap();
    private RunInfo m_runInfo = new RunInfo();
    private String m_host;
    private IMethodInterceptor m_methodInterceptor = new IMethodInterceptor(){

        @Override
        public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
            return this.groupMethodsByInstance(methods);
        }

        private List<IMethodInstance> groupMethodsByInstance(List<IMethodInstance> methods) {
            List instanceList = Lists.newArrayList();
            Map map = Maps.newHashMap();
            for (IMethodInstance mi : methods) {
                Object[] methodInstances;
                for (Object instance : methodInstances = mi.getInstances()) {
                    List l;
                    if (!instanceList.contains(instance)) {
                        instanceList.add(instance);
                    }
                    if ((l = (List)map.get(instance)) == null) {
                        l = Lists.newArrayList();
                        map.put(instance, l);
                    }
                    l.add(mi);
                }
            }
            List<IMethodInstance> result = Lists.newArrayList();
            for (Object instance : instanceList) {
                result.addAll((Collection)map.get(instance));
            }
            return result;
        }
    };
    private ClassMethodMap m_classMethodMap;
    private TestNGClassFinder m_testClassFinder;
    private List<InvokedMethod> m_invokedMethods = Lists.newArrayList();
    private IResultMap m_passedConfigurations = new ResultMap();
    private IResultMap m_skippedConfigurations = new ResultMap();
    private IResultMap m_failedConfigurations = new ResultMap();
    private IAttributes m_attributes = new Attributes();

    public TestRunner(ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder finder, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> invokedMethodListeners) {
        this.init(suite, test, outputDirectory, finder, skipFailedInvocationCounts, invokedMethodListeners);
    }

    public TestRunner(ISuite suite, XmlTest test, IAnnotationFinder finder, boolean skipFailedInvocationCounts) {
        this.init(suite, test, suite.getOutputDirectory(), finder, skipFailedInvocationCounts, null);
    }

    public TestRunner(ISuite suite, XmlTest test, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> listeners) {
        this.init(suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(test.getAnnotations()), skipFailedInvocationCounts, listeners);
    }

    private void init(ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder annotationFinder, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> invokedMethodListeners) {
        this.m_xmlTest = test;
        this.m_suite = suite;
        this.m_testName = test.getName();
        this.m_host = suite.getHost();
        this.m_testClassesFromXml = test.getXmlClasses();
        this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        this.setVerbose(test.getVerbose());
        this.m_packageNamesFromXml = test.getXmlPackages();
        if (null != this.m_packageNamesFromXml) {
            for (XmlPackage xp : this.m_packageNamesFromXml) {
                this.m_testClassesFromXml.addAll(xp.getXmlClasses());
            }
        }
        this.m_annotationFinder = annotationFinder;
        this.m_invoker = new Invoker(this, this, this.m_suite.getSuiteState(), this.m_annotationFinder, this.m_skipFailedInvocationCounts, invokedMethodListeners);
        if (suite.getParallel() != null) {
            this.log(3, "Running the tests in '" + test.getName() + "' with parallel mode:" + suite.getParallel());
        }
        this.setOutputDirectory(outputDirectory);
        this.init();
    }

    public IInvoker getInvoker() {
        return this.m_invoker;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeXmlTestMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterXmlTestMethods;
    }

    private void init() {
        this.initMetaGroups(this.m_xmlTest);
        this.initRunInfo(this.m_xmlTest);
        if (!this.m_xmlTest.isJUnit()) {
            this.initMethods();
        }
        this.initListeners();
        this.addConfigurationListener(this.m_confListener);
    }

    private void initListeners() {
        List<Class> listenerClasses = Lists.newArrayList();
        Class listenerFactoryClass = null;
        for (ITestClass cls : this.getTestClasses()) {
            IAnnotationFinder finder = this.m_annotationFinder;
            Class realClass = cls.getRealClass();
            IListeners l = (IListeners)((Object)finder.findAnnotation(realClass, IListeners.class));
            if (ITestNGListenerFactory.class.isAssignableFrom(realClass)) {
                if (listenerFactoryClass == null) {
                    listenerFactoryClass = realClass;
                } else {
                    throw new TestNGException("Found more than one class implementingITestNGListenerFactory:" + realClass + " and " + listenerFactoryClass);
                }
            }
            if (l == null) continue;
            listenerClasses.addAll(Arrays.asList(l.getValue()));
        }
        ITestNGListenerFactory listenerFactory = null;
        try {
            IClass ic;
            if (this.m_testClassFinder != null && (ic = this.m_testClassFinder.getIClass(listenerFactoryClass)) != null) {
                listenerFactory = (ITestNGListenerFactory)ic.getInstances(false)[0];
            }
            if (listenerFactory == null) {
                listenerFactory = listenerFactoryClass != null ? (ITestNGListenerFactory)listenerFactoryClass.newInstance() : null;
            }
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't instantiate the ITestNGListenerFactory: " + ex);
        }
        for (Class c : listenerClasses) {
            ITestNGListener listener;
            ITestNGListener iTestNGListener = listener = listenerFactory != null ? listenerFactory.createListener(c) : null;
            if (listener == null) {
                listener = ClassHelper.newInstance(c);
            }
            if (listener instanceof IMethodInterceptor) {
                this.setMethodInterceptor((IMethodInterceptor)listener);
                continue;
            }
            if (listener instanceof ISuiteListener) {
                this.addListener((ISuiteListener)listener);
                continue;
            }
            if (listener instanceof IInvokedMethodListener) {
                this.m_suite.addListener(listener);
                continue;
            }
            if (listener instanceof ITestListener) {
                this.addTestListener((ITestListener)listener);
                continue;
            }
            if (!(listener instanceof IReporter)) continue;
            this.m_suite.addListener(listener);
        }
    }

    private void initMetaGroups(XmlTest xmlTest) {
        Map<String, List<String>> metaGroups = xmlTest.getMetaGroups();
        for (String name : metaGroups.keySet()) {
            this.addMetaGroup(name, metaGroups.get(name));
        }
    }

    private void initRunInfo(XmlTest xmlTest) {
        this.m_xmlMethodSelector.setIncludedGroups(this.createGroups(this.m_xmlTest.getIncludedGroups()));
        this.m_xmlMethodSelector.setExcludedGroups(this.createGroups(this.m_xmlTest.getExcludedGroups()));
        this.m_xmlMethodSelector.setExpression(this.m_xmlTest.getExpression());
        this.m_xmlMethodSelector.setXmlClasses(this.m_xmlTest.getXmlClasses());
        this.m_runInfo.addMethodSelector(this.m_xmlMethodSelector, 10);
        if (null != xmlTest.getMethodSelectors()) {
            for (org.testng.xml.XmlMethodSelector selector : xmlTest.getMethodSelectors()) {
                if (selector.getClassName() == null) continue;
                IMethodSelector s = ClassHelper.createSelector(selector);
                this.m_runInfo.addMethodSelector(s, selector.getPriority());
            }
        }
    }

    private void initMethods() {
        IClass[] classes;
        List<ITestNGMethod> beforeClassMethods = Lists.newArrayList();
        List<ITestNGMethod> testMethods = Lists.newArrayList();
        List<ITestNGMethod> afterClassMethods = Lists.newArrayList();
        List<ITestNGMethod> beforeSuiteMethods = Lists.newArrayList();
        List<ITestNGMethod> afterSuiteMethods = Lists.newArrayList();
        List<ITestNGMethod> beforeXmlTestMethods = Lists.newArrayList();
        List<ITestNGMethod> afterXmlTestMethods = Lists.newArrayList();
        this.m_testClassFinder = new TestNGClassFinder(Utils.xmlClassesToClasses(this.m_testClassesFromXml), null, this.m_xmlTest, this.m_annotationFinder, this);
        TestNGMethodFinder testMethodFinder = new TestNGMethodFinder(this.m_runInfo, this.m_annotationFinder);
        this.m_runInfo.setTestMethods(testMethods);
        for (IClass ic : classes = this.m_testClassFinder.findTestClasses()) {
            TestClass tc = new TestClass(ic, this.m_testName, testMethodFinder, this.m_annotationFinder, this.m_runInfo, this.m_xmlTest);
            this.m_classMap.put(ic.getRealClass(), tc);
        }
        Map<String, List<ITestNGMethod>> beforeGroupMethods = MethodHelper.findGroupsMethods(this.m_classMap.values(), true);
        Map<String, List<ITestNGMethod>> afterGroupMethods = MethodHelper.findGroupsMethods(this.m_classMap.values(), false);
        for (ITestClass tc : this.m_classMap.values()) {
            this.fixMethodsWithClass(tc.getTestMethods(), tc, testMethods);
            this.fixMethodsWithClass(tc.getBeforeClassMethods(), tc, beforeClassMethods);
            this.fixMethodsWithClass(tc.getBeforeTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getAfterTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getAfterClassMethods(), tc, afterClassMethods);
            this.fixMethodsWithClass(tc.getBeforeSuiteMethods(), tc, beforeSuiteMethods);
            this.fixMethodsWithClass(tc.getAfterSuiteMethods(), tc, afterSuiteMethods);
            this.fixMethodsWithClass(tc.getBeforeTestConfigurationMethods(), tc, beforeXmlTestMethods);
            this.fixMethodsWithClass(tc.getAfterTestConfigurationMethods(), tc, afterXmlTestMethods);
            this.fixMethodsWithClass(tc.getBeforeGroupsMethods(), tc, MethodHelper.uniqueMethodList(beforeGroupMethods.values()));
            this.fixMethodsWithClass(tc.getAfterGroupsMethods(), tc, MethodHelper.uniqueMethodList(afterGroupMethods.values()));
        }
        this.m_beforeSuiteMethods = MethodHelper.collectAndOrderConfigurationMethods(beforeSuiteMethods, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_beforeXmlTestMethods = MethodHelper.collectAndOrderConfigurationMethods(beforeXmlTestMethods, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_allTestMethods = MethodHelper.collectAndOrderMethods(testMethods, this.m_runInfo, this.m_annotationFinder, this.m_excludedMethods);
        this.m_classMethodMap = new ClassMethodMap(this.m_allTestMethods);
        this.m_afterXmlTestMethods = MethodHelper.collectAndOrderConfigurationMethods(afterXmlTestMethods, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_afterSuiteMethods = MethodHelper.collectAndOrderConfigurationMethods(afterSuiteMethods, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_groupMethods = new ConfigurationGroupMethods(this.m_allTestMethods, beforeGroupMethods, afterGroupMethods);
    }

    private void fixMethodsWithClass(ITestNGMethod[] methods, ITestClass testCls, List<ITestNGMethod> methodList) {
        for (ITestNGMethod itm : methods) {
            itm.setTestClass(testCls);
            if (methodList == null) continue;
            methodList.add(itm);
        }
    }

    public Collection<ITestClass> getTestClasses() {
        return this.m_classMap.values();
    }

    public void setTestName(String name) {
        this.m_testName = name;
    }

    public void setOutputDirectory(String od) {
        this.m_outputDirectory = od;
    }

    private void addMetaGroup(String name, List<String> groupNames) {
        this.m_metaGroups.put(name, groupNames);
    }

    private void collectGroups(String[] groups, List<String> unfinishedGroups, Map<String, String> result) {
        for (String gn : groups) {
            List<String> subGroups = this.m_metaGroups.get(gn);
            if (null == subGroups) continue;
            for (String sg : subGroups) {
                if (null != result.get(sg)) continue;
                result.put(sg, sg);
                unfinishedGroups.add(sg);
            }
        }
    }

    private Map<String, String> createGroups(List<String> groups) {
        return this.createGroups(groups.toArray(new String[groups.size()]));
    }

    private Map<String, String> createGroups(String[] groups) {
        Map<String, String> result = Maps.newHashMap();
        for (String group : groups) {
            result.put(group, group);
        }
        List<String> unfinishedGroups = Lists.newArrayList();
        if (this.m_metaGroups.size() > 0) {
            this.collectGroups(groups, unfinishedGroups, result);
            while (unfinishedGroups.size() > 0) {
                String[] uGroups = unfinishedGroups.toArray(new String[unfinishedGroups.size()]);
                unfinishedGroups = Lists.newArrayList();
                this.collectGroups(uGroups, unfinishedGroups, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.beforeRun();
        try {
            XmlTest test = this.getTest();
            if (test.isJUnit()) {
                this.privateRunJUnit(test);
            } else {
                this.privateRun(test);
            }
            Object var3_2 = null;
            this.afterRun();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.afterRun();
            throw throwable;
        }
    }

    private void beforeRun() {
        this.m_startDate = new Date(System.currentTimeMillis());
        this.logStart();
        this.fireEvent(true);
        ITestNGMethod[] testConfigurationMethods = this.getBeforeTestConfigurationMethods();
        if (null != testConfigurationMethods && testConfigurationMethods.length > 0) {
            this.m_invoker.invokeConfigurations(null, testConfigurationMethods, this.m_xmlTest.getSuite(), this.m_xmlTest.getParameters(), null, null);
        }
    }

    private void privateRunJUnit(XmlTest xmlTest) {
        final Class[] classes = Utils.xmlClassesToClasses(this.m_testClassesFromXml);
        final List runMethods = Lists.newArrayList();
        List workers = Lists.newArrayList();
        workers.add(new IMethodWorker(){

            @Override
            public long getMaxTimeOut() {
                return 0L;
            }

            @Override
            public List<ITestResult> getTestResults() {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Class[] arr$ = classes;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    block6: {
                        Object var8_7;
                        if (i$ >= len$) {
                            return;
                        }
                        Class tc = arr$[i$];
                        IJUnitTestRunner tr = ClassHelper.createTestRunner(TestRunner.this);
                        try {
                            try {
                                tr.run(tc);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                var8_7 = null;
                                runMethods.addAll(tr.getTestMethods());
                                break block6;
                            }
                            var8_7 = null;
                            runMethods.addAll(tr.getTestMethods());
                        }
                        catch (Throwable throwable) {
                            var8_7 = null;
                            runMethods.addAll(tr.getTestMethods());
                            throw throwable;
                        }
                    }
                    ++i$;
                }
            }

            @Override
            public List<ITestNGMethod> getMethods() {
                throw new TestNGException("JUnit not supported");
            }

            @Override
            public int getPriority() {
                if (TestRunner.this.m_allTestMethods.length == 1) {
                    return TestRunner.this.m_allTestMethods[0].getPriority();
                }
                return 0;
            }

            @Override
            public int compareTo(IMethodWorker other) {
                return this.getPriority() - other.getPriority();
            }
        });
        this.runWorkers(workers, "", null);
        this.m_allTestMethods = runMethods.toArray(new ITestNGMethod[runMethods.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void privateRun(XmlTest xmlTest) {
        boolean parallel;
        List<List<ITestNGMethod>> sequentialList = Lists.newArrayList();
        List<ITestNGMethod> parallelList = Lists.newArrayList();
        MapList<Integer, ITestNGMethod> sequentialMapList = new MapList<Integer, ITestNGMethod>();
        String parallelMode = xmlTest.getParallel();
        boolean bl = parallel = "methods".equals(parallelMode) || "true".equalsIgnoreCase(parallelMode) || "classes".equals(parallelMode);
        if (!parallel) {
            this.computeTestLists(sequentialList, parallelList, sequentialMapList);
            this.log(3, "Found " + (sequentialList.size() + parallelList.size()) + " applicable methods");
            List<TestMethodWorker> workers = Lists.newArrayList();
            this.createSequentialWorkers(sequentialList, xmlTest.getParameters(), this.m_classMethodMap, workers);
            MapList<Integer, TestMethodWorker> ml = this.createSequentialWorkers(sequentialMapList, xmlTest.getParameters(), this.m_classMethodMap);
            this.createParallelWorkers(parallelList, xmlTest, this.m_classMethodMap, workers);
            try {
                Collections.sort(workers);
                this.runWorkers(workers, xmlTest.getParallel(), ml);
                Object var10_11 = null;
                this.m_classMethodMap.clear();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.m_classMethodMap.clear();
                throw throwable;
            }
        }
        int threadCount = xmlTest.getThreadCount();
        DynamicGraph<ITestNGMethod> graph = this.computeAlternateTestList(this.m_allTestMethods);
        GroupThreadPoolExecutor executor = new GroupThreadPoolExecutor(this, xmlTest, threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), graph);
        executor.run();
        try {
            executor.awaitTermination(10000L, TimeUnit.SECONDS);
            executor.shutdownNow();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<IMethodWorker> createWorkers(XmlTest xmlTest, Set<ITestNGMethod> methods) {
        List<IMethodWorker> result = Lists.newArrayList();
        Set sequentialClasses = Sets.newHashSet();
        for (ITestNGMethod m : methods) {
            Class cls = m.getRealClass();
            ITestAnnotation test = (ITestAnnotation)this.m_annotationFinder.findAnnotation(cls, ITestAnnotation.class);
            if ((test == null || !test.getSequential()) && !"classes".equals(xmlTest.getParallel())) continue;
            sequentialClasses.add(cls);
        }
        List<IMethodInstance> methodInstances = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            methodInstances.addAll(this.methodsToMultipleMethodInstances(tm));
        }
        methodInstances = this.m_methodInterceptor.intercept(methodInstances, this);
        Map<String, String> params = xmlTest.getParameters();
        Map<Class, Set<IMethodInstance>> list = this.groupMethodInstancesByClass(methodInstances);
        Set processedClasses = Sets.newHashSet();
        for (IMethodInstance im : methodInstances) {
            TestMethodWorker worker;
            Class c = im.getMethod().getTestClass().getRealClass();
            if (sequentialClasses.contains(c)) {
                if (processedClasses.contains(c)) continue;
                processedClasses.add(c);
                worker = new TestMethodWorker(this.m_invoker, this.findClasses(methodInstances, c), this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, this.m_classMethodMap, this);
                result.add(worker);
                continue;
            }
            worker = new TestMethodWorker(this.m_invoker, new IMethodInstance[]{im}, this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, this.m_classMethodMap, this);
            result.add(worker);
        }
        Collections.sort(result);
        return result;
    }

    private IMethodInstance[] findClasses(List<IMethodInstance> methodInstances, Class<?> c) {
        List result = Lists.newArrayList();
        for (IMethodInstance mi : methodInstances) {
            if (mi.getMethod().getTestClass().getRealClass() != c) continue;
            result.add(mi);
        }
        return result.toArray(new IMethodInstance[result.size()]);
    }

    private void createParallelWorkers(List<ITestNGMethod> parallel, XmlTest xmlTest, ClassMethodMap cmm, List<TestMethodWorker> workers) {
        if (parallel.isEmpty()) {
            return;
        }
        List<IMethodInstance> methodInstances = Lists.newArrayList();
        for (ITestNGMethod tm : parallel) {
            methodInstances.addAll(this.methodsToMultipleMethodInstances(tm));
        }
        methodInstances = this.m_methodInterceptor.intercept(methodInstances, this);
        if (TestRunner.getVerbose() >= 2) {
            this.log(3, "WILL BE RUN IN RANDOM ORDER:");
            for (IMethodInstance mi : methodInstances) {
                this.log(3, "  " + mi.getMethod());
                this.log(3, "      on instances");
                for (Object o : mi.getInstances()) {
                    this.log(3, "     " + o);
                }
            }
            this.log(3, "===");
        }
        Map<String, String> params = xmlTest.getParameters();
        if ("classes".equals(xmlTest.getParallel())) {
            Map<Class, Set<IMethodInstance>> list = this.groupMethodInstancesByClass(methodInstances);
            for (Set<IMethodInstance> s : list.values()) {
                workers.add(new TestMethodWorker(this.m_invoker, s.toArray(new IMethodInstance[s.size()]), this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, cmm, this));
            }
        } else {
            for (IMethodInstance mi : methodInstances) {
                workers.add(new TestMethodWorker(this.m_invoker, new IMethodInstance[]{mi}, this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, cmm, this));
            }
        }
    }

    private Map<Class, Set<IMethodInstance>> groupMethodInstancesByClass(List<IMethodInstance> instances) {
        Map<Class, Set<IMethodInstance>> result = Maps.newHashMap();
        for (IMethodInstance mi : instances) {
            Class cl = mi.getMethod().getTestClass().getRealClass();
            Set<IMethodInstance> methods = result.get(cl);
            if (methods == null) {
                methods = new HashSet<IMethodInstance>();
                result.put(cl, methods);
            }
            methods.add(mi);
        }
        return result;
    }

    private void createSequentialWorkers(List<List<ITestNGMethod>> sequentialList, Map<String, String> params, ClassMethodMap cmm, List<TestMethodWorker> workers) {
        if (sequentialList.isEmpty()) {
            return;
        }
        for (List<ITestNGMethod> sl : sequentialList) {
            workers.add(new TestMethodWorker(this.m_invoker, this.methodsToMethodInstances(sl), this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, cmm, this));
        }
        if (TestRunner.getVerbose() >= 2) {
            this.log(3, "WILL BE RUN SEQUENTIALLY:");
            for (List<ITestNGMethod> l : sequentialList) {
                for (ITestNGMethod tm : l) {
                    this.log(3, "  " + tm);
                }
                this.log(3, "====");
            }
            this.log(3, "===");
        }
    }

    private MapList<Integer, TestMethodWorker> createSequentialWorkers(MapList<Integer, ITestNGMethod> mapList, Map<String, String> params, ClassMethodMap cmm) {
        MapList<Integer, TestMethodWorker> result = new MapList<Integer, TestMethodWorker>();
        for (Integer i : mapList.getKeys()) {
            result.put(i, new TestMethodWorker(this.m_invoker, this.methodsToMethodInstances(mapList.get(i)), this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, cmm, this));
        }
        if (TestRunner.getVerbose() >= 2) {
            this.log(3, "WILL BE RUN SEQUENTIALLY:" + result);
        }
        return result;
    }

    private List<MethodInstance> methodsToMultipleMethodInstances(ITestNGMethod ... sl) {
        List<MethodInstance> vResult = Lists.newArrayList();
        for (ITestNGMethod m : sl) {
            Object[] instances;
            for (Object instance : instances = m.getTestClass().getInstances(true)) {
                vResult.add(new MethodInstance(m, new Object[]{instance}));
            }
        }
        return vResult;
    }

    private MethodInstance[] methodsToMethodInstances(List<ITestNGMethod> sl) {
        MethodInstance[] result = new MethodInstance[sl.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new MethodInstance(sl.get(i), sl.get(i).getTestClass().getInstances(true));
        }
        return result;
    }

    private void runWorkers(List<? extends IMethodWorker> workers, String parallelMode, MapList<Integer, TestMethodWorker> sequentialWorkers) {
        if ("methods".equals(parallelMode) || "true".equalsIgnoreCase(parallelMode) || "classes".equals(parallelMode)) {
            long maxTimeOut = this.m_xmlTest.getTimeOut(10000L);
            for (IMethodWorker iMethodWorker : workers) {
                long mt = iMethodWorker.getMaxTimeOut();
                if (mt <= maxTimeOut) continue;
                maxTimeOut = mt;
            }
            ThreadUtil.execute(workers, this.m_xmlTest.getThreadCount(), maxTimeOut, false);
        } else {
            for (IMethodWorker iMethodWorker : workers) {
                iMethodWorker.run();
            }
        }
    }

    private void afterRun() {
        ITestNGMethod[] testConfigurationMethods = this.getAfterTestConfigurationMethods();
        if (null != testConfigurationMethods && testConfigurationMethods.length > 0) {
            this.m_invoker.invokeConfigurations(null, testConfigurationMethods, this.m_xmlTest.getSuite(), this.m_xmlTest.getParameters(), null, null);
        }
        this.m_endDate = new Date(System.currentTimeMillis());
        if (TestRunner.getVerbose() >= 3) {
            this.dumpInvokedMethods();
        }
        this.fireEvent(false);
    }

    private boolean containsString(Map<String, String> regexps, String group) {
        for (String regexp : regexps.values()) {
            boolean match = Pattern.matches(regexp, group);
            if (!match) continue;
            return true;
        }
        return false;
    }

    private DynamicGraph<ITestNGMethod> computeAlternateTestList(ITestNGMethod[] methods) {
        DynamicGraph<ITestNGMethod> result = new DynamicGraph<ITestNGMethod>();
        Map<String, ITestNGMethod> map = Maps.newHashMap();
        MapList<String, ITestNGMethod> groups = new MapList<String, ITestNGMethod>();
        for (ITestNGMethod m : methods) {
            map.put(m.getTestClass().getName() + "." + m.getMethodName(), m);
            for (String g : m.getGroups()) {
                groups.put(g, m);
            }
        }
        for (ITestNGMethod m : methods) {
            result.addNode(m);
            String[] dependentMethods = m.getMethodsDependedUpon();
            if (dependentMethods != null) {
                for (String d : dependentMethods) {
                    ITestNGMethod dm = (ITestNGMethod)map.get(d);
                    if (dm == null) {
                        throw new TestNGException("Method \"" + m + "\" depends on nonexistent method \"" + d + "\"");
                    }
                    result.addEdge(m, dm);
                }
            }
            String[] dependentGroups = m.getGroupsDependedUpon();
            for (String d : dependentGroups) {
                List dg = groups.get(d);
                if (dg == null) {
                    throw new TestNGException("Method \"" + m + "\" depends on nonexistent group \"" + d + "\"");
                }
                for (ITestNGMethod ddm : dg) {
                    result.addEdge(m, ddm);
                }
            }
        }
        return result;
    }

    private void computeTestLists(List<List<ITestNGMethod>> sl, List<ITestNGMethod> parallelList, MapList<Integer, ITestNGMethod> outSequentialList) {
        Map<String, String> groupsDependedUpon = Maps.newHashMap();
        Map<String, String> methodsDependedUpon = Maps.newHashMap();
        Map sequentialAttributeList = Maps.newHashMap();
        List<ITestNGMethod> sequentialList = Lists.newArrayList();
        for (int i = this.m_allTestMethods.length - 1; i >= 0; --i) {
            ITestNGMethod tm = this.m_allTestMethods[i];
            Class cls = tm.getRealClass();
            ITestAnnotation test = (ITestAnnotation)this.m_annotationFinder.findAnnotation(cls, ITestAnnotation.class);
            if (test != null && test.getSequential()) {
                String className = tm.getTestClass().getName();
                List list = (List)sequentialAttributeList.get(className);
                if (list == null) {
                    list = Lists.newArrayList();
                    sequentialAttributeList.put(className, list);
                }
                list.add(0, tm);
                continue;
            }
            String[] currentGroups = tm.getGroups();
            String[] currentGroupsDependedUpon = tm.getGroupsDependedUpon();
            String[] currentMethodsDependedUpon = tm.getMethodsDependedUpon();
            String thisMethodName = tm.getMethod().getDeclaringClass().getName() + "." + tm.getMethod().getName();
            if (currentGroupsDependedUpon.length > 0) {
                for (String gdu : currentGroupsDependedUpon) {
                    groupsDependedUpon.put(gdu, gdu);
                }
                sequentialList.add(0, tm);
                continue;
            }
            if (currentMethodsDependedUpon.length > 0) {
                for (String cmu : currentMethodsDependedUpon) {
                    methodsDependedUpon.put(cmu, cmu);
                }
                sequentialList.add(0, tm);
                continue;
            }
            if (this.containsString(methodsDependedUpon, thisMethodName)) {
                int index = 0;
                for (int j = 0; j < sequentialList.size(); ++j) {
                    ITestNGMethod m = sequentialList.get(j);
                    if (!this.arrayContains(m.getMethodsDependedUpon(), thisMethodName)) continue;
                    index = j;
                    break;
                }
                sequentialList.add(index, tm);
                continue;
            }
            if (currentGroups.length > 0) {
                boolean isSequential = false;
                for (String group : currentGroups) {
                    if (!this.containsString(groupsDependedUpon, group)) continue;
                    sequentialList.add(0, tm);
                    isSequential = true;
                    break;
                }
                if (isSequential) continue;
                parallelList.add(0, tm);
                continue;
            }
            parallelList.add(0, tm);
        }
        if (sequentialList.size() > 0) {
            sl.add(sequentialList);
        }
        String previousGroup = "";
        int index = 0;
        for (ITestNGMethod m : sequentialList) {
            String[] g = m.getGroupsDependedUpon();
            if (g.length > 0 && !m.getGroupsDependedUpon()[0].equals(previousGroup)) {
                ++index;
                previousGroup = m.getGroupsDependedUpon()[0];
            }
            outSequentialList.put(index, m);
        }
        sl.addAll(sequentialAttributeList.values());
    }

    private boolean arrayContains(String[] array, String element) {
        for (String a : array) {
            if (!element.equals(a)) continue;
            return true;
        }
        return false;
    }

    private void logStart() {
        this.log(3, "Running test " + this.m_testName + " on " + this.m_classMap.size() + " " + " classes, " + " included groups:[" + this.mapToString(this.m_xmlMethodSelector.getIncludedGroups()) + "] excluded groups:[" + this.mapToString(this.m_xmlMethodSelector.getExcludedGroups()) + "]");
        if (TestRunner.getVerbose() >= 3) {
            for (ITestClass tc : this.m_classMap.values()) {
                ((TestClass)tc).dump();
            }
        }
    }

    private void fireEvent(boolean isStart) {
        for (ITestListener itl : this.m_testListeners) {
            if (isStart) {
                itl.onStart(this);
                continue;
            }
            itl.onFinish(this);
        }
    }

    @Override
    public String getName() {
        return this.m_testName;
    }

    @Override
    public Date getStartDate() {
        return this.m_startDate;
    }

    @Override
    public Date getEndDate() {
        return this.m_endDate;
    }

    @Override
    public IResultMap getPassedTests() {
        return this.m_passedTests;
    }

    @Override
    public IResultMap getSkippedTests() {
        return this.m_skippedTests;
    }

    @Override
    public IResultMap getFailedTests() {
        return this.m_failedTests;
    }

    @Override
    public IResultMap getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    @Override
    public String[] getIncludedGroups() {
        Map<String, String> ig = this.m_xmlMethodSelector.getIncludedGroups();
        String[] result = ig.values().toArray(new String[ig.size()]);
        return result;
    }

    @Override
    public String[] getExcludedGroups() {
        Map<String, String> eg = this.m_xmlMethodSelector.getExcludedGroups();
        String[] result = eg.values().toArray(new String[eg.size()]);
        return result;
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    @Override
    public ISuite getSuite() {
        return this.m_suite;
    }

    @Override
    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        Map<ITestNGMethod, ITestNGMethod> vResult = Maps.newHashMap();
        for (ITestNGMethod m : this.m_excludedMethods) {
            vResult.put(m, m);
        }
        return vResult.keySet();
    }

    @Override
    public IResultMap getFailedConfigurations() {
        return this.m_failedConfigurations;
    }

    @Override
    public IResultMap getPassedConfigurations() {
        return this.m_passedConfigurations;
    }

    @Override
    public IResultMap getSkippedConfigurations() {
        return this.m_skippedConfigurations;
    }

    @Override
    public void addPassedTest(ITestNGMethod tm, ITestResult tr) {
        this.m_passedTests.addResult(tr, tm);
    }

    @Override
    public Set<ITestResult> getPassedTests(ITestNGMethod tm) {
        return this.m_passedTests.getResults(tm);
    }

    @Override
    public void addSkippedTest(ITestNGMethod tm, ITestResult tr) {
        this.m_skippedTests.addResult(tr, tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInvokedMethod(InvokedMethod im) {
        List<InvokedMethod> list = this.m_invokedMethods;
        synchronized (list) {
            this.m_invokedMethods.add(im);
        }
    }

    @Override
    public void addFailedTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, false);
    }

    @Override
    public void addFailedButWithinSuccessPercentageTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, true);
    }

    @Override
    public XmlTest getTest() {
        return this.m_xmlTest;
    }

    @Override
    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    @Override
    public List<IConfigurationListener> getConfigurationListeners() {
        return this.m_configurationListeners;
    }

    private void logFailedTest(ITestNGMethod method, ITestResult tr, boolean withinSuccessPercentage) {
        this.m_passedTests.removeResult(method);
        if (withinSuccessPercentage) {
            this.m_failedButWithinSuccessPercentageTests.addResult(tr, method);
        } else {
            this.m_failedTests.addResult(tr, method);
        }
    }

    private String mapToString(Map<?, ?> m) {
        StringBuffer result = new StringBuffer();
        for (Object o : m.values()) {
            result.append(o.toString()).append(" ");
        }
        return result.toString();
    }

    private void log(int level, String s) {
        Utils.log("TestRunner", level, s);
    }

    public static int getVerbose() {
        return m_verbose;
    }

    public void setVerbose(int n) {
        m_verbose = n;
    }

    private void log(String s) {
        Utils.log("TestRunner", 2, s);
    }

    public void addListener(Object listener) {
        if (listener instanceof ITestListener) {
            this.addTestListener((ITestListener)listener);
        }
        if (listener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)listener);
        }
    }

    public void addTestListener(ITestListener il) {
        this.m_testListeners.add(il);
    }

    public void addConfigurationListener(IConfigurationListener icl) {
        this.m_configurationListeners.add(icl);
    }

    private void dumpInvokedMethods() {
        System.out.println("\n*********** INVOKED METHODS\n");
        for (InvokedMethod im : this.m_invokedMethods) {
            if (im.isTestMethod()) {
                System.out.print("\t\t");
            } else {
                if (!im.isConfigurationMethod()) continue;
                System.out.print("\t");
            }
            System.out.println("" + im);
        }
        System.out.println("\n***********\n");
    }

    public List<ITestNGMethod> getInvokedMethods() {
        List<ITestNGMethod> result = Lists.newArrayList();
        for (InvokedMethod im : this.m_invokedMethods) {
            ITestNGMethod tm = im.getTestMethod();
            tm.setDate(im.getDate());
            result.add(tm);
        }
        return result;
    }

    public void setMethodInterceptor(IMethodInterceptor methodInterceptor) {
        this.m_methodInterceptor = methodInterceptor;
    }

    @Override
    public XmlTest getCurrentXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public Object getAttribute(String name) {
        return this.m_attributes.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.m_attributes.setAttribute(name, value);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String name) {
        return this.m_attributes.removeAttribute(name);
    }

    private class ConfigurationListener
    implements IConfigurationListener {
        private ConfigurationListener() {
        }

        public void onConfigurationFailure(ITestResult itr) {
            TestRunner.this.m_failedConfigurations.addResult(itr, itr.getMethod());
        }

        public void onConfigurationSkip(ITestResult itr) {
            TestRunner.this.m_skippedConfigurations.addResult(itr, itr.getMethod());
        }

        public void onConfigurationSuccess(ITestResult itr) {
            TestRunner.this.m_passedConfigurations.addResult(itr, itr.getMethod());
        }
    }
}

