/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.InjectionsSettingsUI;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;

public class EditInjectionSettingsAction
implements IntentionAction {
    public static final String EDIT_INJECTION_TITLE = "Language Injection Settings";

    @NotNull
    public String getText() {
        if (EDIT_INJECTION_TITLE == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction.getText must not return null");
        }
        return EDIT_INJECTION_TITLE;
    }

    @NotNull
    public String getFamilyName() {
        if ("Edit Injection Settings" == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction.getFamilyName must not return null");
        }
        return "Edit Injection Settings";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction.isAvailable must not be null");
        }
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return false;
        }
        List injectedPsi = InjectedLanguageUtil.getInjectedPsiFiles((PsiElement)host);
        return injectedPsi != null && !injectedPsi.isEmpty();
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/EditInjectionSettingsAction.invoke must not be null");
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                EditInjectionSettingsAction.invokeImpl(project, editor, file);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeImpl(Project project, Editor editor, PsiFile file) {
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return;
        }
        try {
            for (LanguageInjectionSupport support : (LanguageInjectionSupport[])Extensions.getExtensions(LanguageInjectionSupport.EP_NAME)) {
                if (!support.editInjectionInPlace(host)) continue;
                return;
            }
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new InjectionsSettingsUI(project, Configuration.getInstance()));
        }
        finally {
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

