/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestNGMethod;
import org.testng.Reporter;
import org.testng.internal.Utils;
import org.testng.reporters.XMLReporterConfig;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.XMLSuiteResultWriter;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReporter
implements IReporter {
    private XMLReporterConfig config = new XMLReporterConfig();
    private XMLStringBuffer rootBuffer;

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        if (Utils.isStringEmpty(this.config.getOutputDirectory())) {
            this.config.setOutputDirectory(outputDirectory);
        }
        this.rootBuffer = new XMLStringBuffer("");
        this.rootBuffer.push("testng-results");
        this.writeReporterOutput(this.rootBuffer);
        for (int i = 0; i < suites.size(); ++i) {
            this.writeSuite(xmlSuites.get(i), suites.get(i));
        }
        this.rootBuffer.pop();
        Utils.writeUtf8File(this.config.getOutputDirectory(), "testng-results.xml", this.rootBuffer.toXML());
    }

    private void writeReporterOutput(XMLStringBuffer xmlBuffer) {
        xmlBuffer.push("reporter-output");
        List<String> output = Reporter.getOutput();
        for (String line : output) {
            if (line == null) continue;
            xmlBuffer.push("line");
            xmlBuffer.addCDATA(line);
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private void writeSuite(XmlSuite xmlSuite, ISuite suite) {
        switch (this.config.getFileFragmentationLevel()) {
            case 1: {
                this.writeSuiteToBuffer(this.rootBuffer, suite);
                break;
            }
            case 2: 
            case 3: {
                File suiteFile = this.referenceSuite(this.rootBuffer, suite);
                this.writeSuiteToFile(suiteFile, suite);
            }
        }
    }

    private void writeSuiteToFile(File suiteFile, ISuite suite) {
        XMLStringBuffer xmlBuffer = new XMLStringBuffer("");
        this.writeSuiteToBuffer(xmlBuffer, suite);
        File parentDir = suiteFile.getParentFile();
        if (parentDir.exists() || suiteFile.getParentFile().mkdirs()) {
            Utils.writeFile(parentDir.getAbsolutePath(), "testng-results.xml", xmlBuffer.toXML());
        }
    }

    private File referenceSuite(XMLStringBuffer xmlBuffer, ISuite suite) {
        String relativePath = new StringBuffer().append(suite.getName()).append(File.separatorChar).append("testng-results.xml").toString();
        File suiteFile = new File(this.config.getOutputDirectory(), relativePath);
        Properties attrs = new Properties();
        attrs.setProperty("url", relativePath);
        xmlBuffer.addEmptyElement("suite", attrs);
        return suiteFile;
    }

    private void writeSuiteToBuffer(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("suite", this.getSuiteAttributes(suite));
        this.writeSuiteGroups(xmlBuffer, suite);
        Map<String, ISuiteResult> results = suite.getResults();
        XMLSuiteResultWriter suiteResultWriter = new XMLSuiteResultWriter(this.config);
        for (Map.Entry<String, ISuiteResult> result : results.entrySet()) {
            suiteResultWriter.writeSuiteResult(xmlBuffer, result.getValue());
        }
        xmlBuffer.pop();
    }

    private void writeSuiteGroups(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("groups");
        Map<String, Collection<ITestNGMethod>> methodsByGroups = suite.getMethodsByGroups();
        for (String groupName : methodsByGroups.keySet()) {
            Properties groupAttrs = new Properties();
            groupAttrs.setProperty("name", groupName);
            xmlBuffer.push("group", groupAttrs);
            Set<ITestNGMethod> groupMethods = this.getUniqueMethodSet(methodsByGroups.get(groupName));
            for (ITestNGMethod groupMethod : groupMethods) {
                Properties methodAttrs = new Properties();
                methodAttrs.setProperty("name", groupMethod.getMethodName());
                methodAttrs.setProperty("signature", groupMethod.toString());
                methodAttrs.setProperty("class", groupMethod.getRealClass().getName());
                xmlBuffer.addEmptyElement("method", methodAttrs);
            }
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private Properties getSuiteAttributes(ISuite suite) {
        Properties props = new Properties();
        props.setProperty("name", suite.getName());
        return props;
    }

    private Set<ITestNGMethod> getUniqueMethodSet(Collection<ITestNGMethod> methods) {
        LinkedHashSet<ITestNGMethod> result = new LinkedHashSet<ITestNGMethod>();
        for (ITestNGMethod method : methods) {
            result.add(method);
        }
        return result;
    }

    public int getFileFragmentationLevel() {
        return this.config.getFileFragmentationLevel();
    }

    public void setFileFragmentationLevel(int fileFragmentationLevel) {
        this.config.setFileFragmentationLevel(fileFragmentationLevel);
    }

    public int getStackTraceOutputMethod() {
        return this.config.getStackTraceOutputMethod();
    }

    public void setStackTraceOutputMethod(int stackTraceOutputMethod) {
        this.config.setStackTraceOutputMethod(stackTraceOutputMethod);
    }

    public String getOutputDirectory() {
        return this.config.getOutputDirectory();
    }

    public void setOutputDirectory(String outputDirectory) {
        this.config.setOutputDirectory(outputDirectory);
    }

    public boolean isGenerateGroupsAttribute() {
        return this.config.isGenerateGroupsAttribute();
    }

    public void setGenerateGroupsAttribute(boolean generateGroupsAttribute) {
        this.config.setGenerateGroupsAttribute(generateGroupsAttribute);
    }

    public boolean isSplitClassAndPackageNames() {
        return this.config.isSplitClassAndPackageNames();
    }

    public void setSplitClassAndPackageNames(boolean splitClassAndPackageNames) {
        this.config.setSplitClassAndPackageNames(splitClassAndPackageNames);
    }

    public String getTimestampFormat() {
        return this.config.getTimestampFormat();
    }

    public void setTimestampFormat(String timestampFormat) {
        this.config.setTimestampFormat(timestampFormat);
    }

    public boolean isGenerateDependsOnMethods() {
        return this.config.isGenerateDependsOnMethods();
    }

    public void setGenerateDependsOnMethods(boolean generateDependsOnMethods) {
        this.config.setGenerateDependsOnMethods(generateDependsOnMethods);
    }

    public void setGenerateDependsOnGroups(boolean generateDependsOnGroups) {
        this.config.setGenerateDependsOnGroups(generateDependsOnGroups);
    }

    public boolean isGenerateDependsOnGroups() {
        return this.config.isGenerateDependsOnGroups();
    }
}

