/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.util;

import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FileTypeUtil {
    private final Map<String, FileType> types = new HashMap<String, FileType>();
    private static FileTypeUtil instance;
    private final Map<FileType, Set<FileType>> mappings = new HashMap<FileType, Set<FileType>>();
    private final Set<FileType> noSeparators = new HashSet<FileType>();
    private static final Logger logger;

    public static synchronized FileTypeUtil getInstance() {
        if (instance == null) {
            instance = new FileTypeUtil();
        }
        return instance;
    }

    public static String buildComment(FileType type, String template, LanguageOptions options) {
        int i;
        String open;
        boolean allowLine;
        Commenter commenter = FileTypeUtil.getCommenter(type);
        if (commenter == null) {
            return "<No comments>";
        }
        String bs = commenter.getBlockCommentPrefix();
        String be = commenter.getBlockCommentSuffix();
        String ls = commenter.getLineCommentPrefix();
        if ((bs == null || be == null) && ls == null) {
            return "<No comments>";
        }
        boolean allowBlock = bs != null && be != null;
        boolean bl = allowLine = ls != null;
        if (allowLine && !allowBlock) {
            bs = ls;
            be = ls;
        }
        boolean allowSeparator = FileTypeUtil.getInstance().allowSeparators(type);
        char filler = options.getFiller();
        if (!allowSeparator && options.getFiller() == ' ') {
            filler = '~';
        }
        boolean isBlock = options.isBlock();
        boolean isPrefix = options.isPrefixLines();
        if (isBlock && !allowBlock) {
            isPrefix = true;
        }
        boolean isBox = options.isBox() && options.isSeparateBefore() && options.isSeparateAfter() && options.getLenBefore() == options.getLenAfter();
        StringBuffer preview = new StringBuffer(80);
        String string = isBlock ? bs : (open = allowLine ? ls : bs);
        String close = isBlock ? be : (allowLine ? ls : be);
        StringBuffer pre = new StringBuffer(5);
        StringBuffer leader = new StringBuffer(5);
        StringBuffer post = new StringBuffer(5);
        if (filler == ' ') {
            filler = open.charAt(open.length() - 1);
        }
        int offset = 0;
        if (isBlock) {
            int pos = open.length() - 1;
            pre.append(allowBlock ? filler : open.charAt(pos));
            while (pos > 0 && open.charAt(pos) == open.charAt(open.length() - 1)) {
                --pos;
                ++offset;
            }
            while (open.length() > 1 && pos >= 0) {
                leader.append(' ');
                --pos;
            }
            post.append(filler);
            if (!isPrefix) {
                pre = new StringBuffer(0);
            }
            if (!allowBlock) {
                close = Character.toString(filler);
            }
        } else {
            if (allowLine) {
                close = Character.toString(filler);
            }
            pre.append(open);
            post.append(close);
        }
        int diff = 0;
        if (options.isSeparateBefore()) {
            if (isBlock && isBox && allowBlock) {
                diff = close.length() - offset;
            }
            preview.append(open);
            for (i = open.length() + 1; i <= options.getLenBefore() - diff - post.length(); ++i) {
                preview.append(filler);
            }
            preview.append(post);
            preview.append('\n');
        } else if (isBlock) {
            preview.append(open).append('\n');
        }
        if (template.length() > 0) {
            String[] lines;
            for (String line : lines = template.split("\n", -1)) {
                preview.append(leader).append(pre);
                int len = 0;
                if (pre.length() > 0 && line.length() > 0) {
                    preview.append(' ');
                    ++len;
                }
                preview.append(line);
                if (isBox && (len += line.length() + leader.length() + pre.length()) < options.getLenBefore() - diff) {
                    while (len < options.getLenBefore() - diff - post.length()) {
                        preview.append(' ');
                        ++len;
                    }
                    if (isBlock || allowLine) {
                        preview.append(post.substring(0, options.getLenBefore() - diff - len));
                    }
                }
                if (!isBlock && !allowLine) {
                    if (preview.charAt(preview.length() - 1) != ' ') {
                        preview.append(' ');
                    }
                    preview.append(close);
                }
                preview.append('\n');
            }
        }
        preview.append(leader);
        if (options.isSeparateAfter()) {
            preview.append(pre);
            for (i = leader.length() + pre.length(); i < options.getLenAfter() - close.length(); ++i) {
                preview.append(filler);
            }
            preview.append(close);
            preview.append('\n');
        } else if (isBlock) {
            if (!allowBlock) {
                preview.append(pre).append('\n');
            } else {
                preview.append(close).append('\n');
            }
        }
        return preview.substring(0, preview.length() - 1);
    }

    public boolean isSupportedFile(VirtualFile file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        FileType type = FileTypeManager.getInstance().getFileTypeByFile(file);
        return this.types.get(type.getName()) != null;
    }

    public boolean isSupportedFile(PsiFile file) {
        if (file == null || file instanceof PsiDirectory) {
            return false;
        }
        return FileTypeUtil.isSupportedType(file.getFileType());
    }

    public FileType[] getSupportedTypes() {
        return new HashSet<FileType>(this.types.values()).toArray(new FileType[0]);
    }

    public FileType getFileTypeByFile(VirtualFile file) {
        FileType type = FileTypeManager.getInstance().getFileTypeByFile(file);
        return this.getFileTypeByType(type);
    }

    public FileType getFileTypeByType(FileType type) {
        return this.types.get(type.getName());
    }

    public String getFileTypeNameByName(String name) {
        FileType type = this.types.get(name);
        return type != null ? type.getName() : name;
    }

    public static boolean hasBlockComment(FileType fileType) {
        Commenter commenter = FileTypeUtil.getCommenter(fileType);
        return commenter != null && commenter.getBlockCommentPrefix() != null;
    }

    public static boolean hasLineComment(FileType fileType) {
        Commenter commenter = FileTypeUtil.getCommenter(fileType);
        return commenter != null && commenter.getLineCommentPrefix() != null;
    }

    public boolean allowSeparators(FileType fileType) {
        FileType type = this.getFileTypeByType(fileType);
        return !this.noSeparators.contains(type);
    }

    private FileTypeUtil() {
        this.createMappings();
        this.loadFileTypes();
        FileTypeManager.getInstance().addFileTypeListener(new FileTypeListener(){

            public void beforeFileTypesChanged(FileTypeEvent fileTypeEvent) {
            }

            public void fileTypesChanged(FileTypeEvent fileTypeEvent) {
                FileTypeUtil.this.loadFileTypes();
            }
        });
    }

    private static Commenter getCommenter(FileType fileType) {
        if (fileType instanceof LanguageFileType) {
            return (Commenter)LanguageCommenters.INSTANCE.forLanguage(((LanguageFileType)fileType).getLanguage());
        }
        return null;
    }

    private void createMappings() {
        HashSet<LanguageFileType> maps = new HashSet<LanguageFileType>();
        maps.add(StdFileTypes.DTD);
        maps.add(StdFileTypes.XML);
        this.mappings.put((FileType)StdFileTypes.XML, maps);
        maps = new HashSet();
        maps.add(StdFileTypes.HTML);
        maps.add(StdFileTypes.XHTML);
        this.mappings.put((FileType)StdFileTypes.HTML, maps);
        maps = new HashSet();
        maps.add(StdFileTypes.JSP);
        this.mappings.put((FileType)StdFileTypes.JSP, maps);
        this.noSeparators.add((FileType)StdFileTypes.XML);
        this.noSeparators.add((FileType)StdFileTypes.HTML);
        this.noSeparators.add((FileType)StdFileTypes.JSP);
        this.noSeparators.add((FileType)StdFileTypes.JSPX);
    }

    private static boolean isSupportedType(FileType type) {
        boolean hasComment;
        if (type.isBinary() || type.getName().indexOf("IDEA") >= 0 || "GUI_DESIGNER_FORM".equals(type.getName())) {
            return false;
        }
        Commenter commenter = FileTypeUtil.getCommenter(type);
        boolean bl = hasComment = commenter != null && (commenter.getLineCommentPrefix() != null || commenter.getBlockCommentPrefix() != null);
        if (!hasComment) {
            return false;
        }
        if (type.equals(StdFileTypes.JAVA)) {
            return true;
        }
        if (type.equals(StdFileTypes.XML)) {
            return true;
        }
        if (type.equals(StdFileTypes.DTD)) {
            return true;
        }
        if (type.equals(StdFileTypes.HTML)) {
            return true;
        }
        if (type.equals(StdFileTypes.XHTML)) {
            return true;
        }
        if (type.equals(StdFileTypes.JSP)) {
            return true;
        }
        if (type.equals(StdFileTypes.JSPX)) {
            return true;
        }
        if (type.equals(StdFileTypes.PROPERTIES)) {
            return true;
        }
        if ("JavaScript".equals(type.getName())) {
            return true;
        }
        return CopyrightUpdaters.INSTANCE.forFileType(type) != null;
    }

    private void loadFileTypes() {
        FileType[] ftypes;
        logger.debug("loadFileTypes");
        this.types.clear();
        for (FileType ftype : ftypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (FileTypeUtil.isSupportedType(ftype)) {
                logger.debug("adding " + ftype.getName());
                Iterator<FileType> iter = this.mappings.keySet().iterator();
                FileType type = ftype;
                while (iter.hasNext()) {
                    FileType fileType = iter.next();
                    Set<FileType> maps = this.mappings.get(fileType);
                    if (!maps.contains(ftype)) continue;
                    type = fileType;
                    break;
                }
                this.types.put(ftype.getName(), type);
                continue;
            }
            logger.debug("ignoring " + ftype.getName());
        }
    }

    static {
        logger = Logger.getInstance((String)FileTypeUtil.class.getName());
    }

    public static class SortByName
    implements Comparator<FileType> {
        @Override
        public int compare(FileType a, FileType b) {
            return a.getName().compareToIgnoreCase(b.getName());
        }
    }
}

