/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.lang.properties.references.I18nizeQuickFixModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreatePropertyFix
implements IntentionAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.i18n.I18nizeQuickFix");
    private final PsiElement myElement;
    private final String myKey;
    private final List<PropertiesFile> myPropertiesFiles;
    public static final String NAME = PropertiesBundle.message("create.property.quickfix.text", new Object[0]);

    public CreatePropertyFix() {
        this(null, null, null);
    }

    public CreatePropertyFix(PsiElement element, String key, List<PropertiesFile> propertiesFiles) {
        this.myElement = element;
        this.myKey = key;
        this.myPropertiesFiles = propertiesFiles;
    }

    @NotNull
    public String getName() {
        String string = NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/CreatePropertyFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/CreatePropertyFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.applyFix must not be null");
        }
        PsiElement psiElement = descriptor.getPsiElement();
        if (this.isAvailable(project, null, null)) {
            this.invoke(project, null, psiElement.getContainingFile());
        }
    }

    @NotNull
    public String getText() {
        String string = NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/CreatePropertyFix.getText must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.isAvailable must not be null");
        }
        return this.myElement.isValid();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.invoke must not be null");
        }
        CreatePropertyFix.invokeAction(project, file, this.myElement, this.myKey, this.myPropertiesFiles);
    }

    @Nullable
    private static Pair<String, String> invokeAction(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement psiElement, @Nullable String suggestedKey, final @Nullable List<PropertiesFile> propertiesFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.invokeAction must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.invokeAction must not be null");
        }
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.invokeAction must not be null");
        }
        final I18nizeQuickFixDialog.DialogCustomization dialogCustomization = CreatePropertyFix.createDefaultCustomization(suggestedKey, propertiesFiles);
        I18nizeQuickFixModel model = ApplicationManager.getApplication().isUnitTestMode() ? new I18nizeQuickFixModel(){

            @Override
            public String getValue() {
                return "";
            }

            @Override
            public String getKey() {
                return dialogCustomization.getSuggestedName();
            }

            @Override
            public boolean hasValidData() {
                return true;
            }

            @Override
            public Collection<PropertiesFile> getAllPropertiesFiles() {
                return propertiesFiles;
            }
        } : new I18nizeQuickFixDialog(project, file, NAME, dialogCustomization);
        return CreatePropertyFix.doAction(project, psiElement, model);
    }

    protected static I18nizeQuickFixDialog.DialogCustomization createDefaultCustomization(String suggestedKey, List<PropertiesFile> propertiesFiles) {
        return new I18nizeQuickFixDialog.DialogCustomization(NAME, false, true, propertiesFiles, suggestedKey == null ? "" : suggestedKey);
    }

    protected static Pair<String, String> doAction(Project project, PsiElement psiElement, I18nizeQuickFixModel model) {
        if (!model.hasValidData()) {
            return null;
        }
        String key = model.getKey();
        String value = model.getValue();
        Collection<PropertiesFile> selectedPropertiesFiles = model.getAllPropertiesFiles();
        CreatePropertyFix.createProperty(project, psiElement, selectedPropertiesFiles, key, value);
        return new Pair((Object)key, (Object)value);
    }

    public static void createProperty(final @NotNull Project project, @NotNull PsiElement psiElement, final @NotNull Collection<PropertiesFile> selectedPropertiesFiles, final @NotNull String key, final @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.createProperty must not be null");
        }
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.createProperty must not be null");
        }
        if (selectedPropertiesFiles == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.createProperty must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.createProperty must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/properties/references/CreatePropertyFix.createProperty must not be null");
        }
        for (PropertiesFile selectedFile : selectedPropertiesFiles) {
            if (CodeInsightUtilBase.prepareFileForWrite((PsiFile)selectedFile)) continue;
            return;
        }
        UndoUtil.markPsiFileForUndo((PsiFile)psiElement.getContainingFile());
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            I18nUtil.createProperty(project, selectedPropertiesFiles, key, value);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }, CodeInsightBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

