/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PropertyFileIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesReferenceManager {
    private final PsiManager myPsiManager;

    public static PropertiesReferenceManager getInstance(Project project) {
        return (PropertiesReferenceManager)ServiceManager.getService((Project)project, PropertiesReferenceManager.class);
    }

    public PropertiesReferenceManager(PsiManager psiManager) {
        this.myPsiManager = psiManager;
    }

    @NotNull
    public List<PropertiesFile> findPropertiesFiles(@NotNull Module module, String bundleName) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/PropertiesReferenceManager.findPropertiesFiles must not be null");
        }
        List<PropertiesFile> list = this.findPropertiesFiles(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), bundleName, BundleNameEvaluator.DEFAULT);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesReferenceManager.findPropertiesFiles must not return null");
        }
        return list;
    }

    @NotNull
    public List<PropertiesFile> findPropertiesFiles(@NotNull GlobalSearchScope searchScope, final String bundleName, BundleNameEvaluator bundleNameEvaluator) {
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/PropertiesReferenceManager.findPropertiesFiles must not be null");
        }
        final ArrayList<PropertiesFile> result = new ArrayList<PropertiesFile>();
        this.processPropertiesFiles(searchScope, new PropertiesFileProcessor(){

            @Override
            public boolean process(String baseName, PropertiesFile propertiesFile) {
                if (baseName.equals(bundleName)) {
                    result.add(propertiesFile);
                }
                return true;
            }
        }, bundleNameEvaluator);
        ArrayList<PropertiesFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesReferenceManager.findPropertiesFiles must not return null");
        }
        return arrayList;
    }

    @Nullable
    public PropertiesFile findPropertiesFile(Module module, String bundleName, Locale locale) {
        List<PropertiesFile> propFiles = this.findPropertiesFiles(module, bundleName);
        if (locale != null) {
            for (PropertiesFile propFile : propFiles) {
                if (!propFile.getLocale().equals(locale)) continue;
                return propFile;
            }
        }
        for (PropertiesFile propFile : propFiles) {
            if (propFile.getLocale().getLanguage().length() != 0 && !propFile.getLocale().equals(Locale.getDefault())) continue;
            return propFile;
        }
        if (!propFiles.isEmpty()) {
            return propFiles.get(0);
        }
        return null;
    }

    public String[] getPropertyFileBaseNames(@NotNull GlobalSearchScope searchScope, BundleNameEvaluator bundleNameEvaluator) {
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/PropertiesReferenceManager.getPropertyFileBaseNames must not be null");
        }
        final ArrayList result = new ArrayList();
        this.processPropertiesFiles(searchScope, new PropertiesFileProcessor(){

            @Override
            public boolean process(String baseName, PropertiesFile propertiesFile) {
                result.add(baseName);
                return true;
            }
        }, bundleNameEvaluator);
        return ArrayUtil.toStringArray(result);
    }

    private boolean processPropertiesFiles(@NotNull GlobalSearchScope searchScope, final @NotNull PropertiesFileProcessor processor, final @NotNull BundleNameEvaluator evaluator) {
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/PropertiesReferenceManager.processPropertiesFiles must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/PropertiesReferenceManager.processPropertiesFiles must not be null");
        }
        if (evaluator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/properties/PropertiesReferenceManager.processPropertiesFiles must not be null");
        }
        if (PropertyFileIndex.DEBUG) {
            System.out.println("PropertiesReferenceManager.processPropertiesFiles");
            System.out.println("PropertiesFileType.FILE_TYPE = " + PropertiesFileType.FILE_TYPE);
        }
        return FileBasedIndex.getInstance().processValues(PropertyFileIndex.NAME, (Object)PropertiesFileType.FILE_TYPE.getName(), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>(){

            public boolean process(VirtualFile file, Void value) {
                String qName;
                PsiFile psiFile;
                if (PropertyFileIndex.DEBUG) {
                    System.out.println("file = " + file.getPath());
                }
                return !((psiFile = PropertiesReferenceManager.this.myPsiManager.findFile(file)) instanceof PropertiesFile) || (qName = evaluator.evaluateBundleName(psiFile)) == null || processor.process(qName, (PropertiesFile)psiFile);
            }
        }, searchScope);
    }

    static interface PropertiesFileProcessor {
        public boolean process(String var1, PropertiesFile var2);
    }
}

