/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.SplitterFactory;
import com.intellij.spellchecker.tokenizer.Token;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiIdentifierOwnerTokenizer
extends Tokenizer<PsiNameIdentifierOwner> {
    @Override
    @Nullable
    public Token[] tokenize(@NotNull PsiNameIdentifierOwner element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/tokenizer/PsiIdentifierOwnerTokenizer.tokenize must not be null");
        }
        PsiElement identifier = element.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        PsiNameIdentifierOwner parent = element;
        int offset = identifier.getTextRange().getStartOffset() - parent.getTextRange().getStartOffset();
        if (offset < 0) {
            parent = PsiTreeUtil.findCommonParent((PsiElement)identifier, (PsiElement)element);
            offset = identifier.getTextRange().getStartOffset() - parent.getTextRange().getStartOffset();
        }
        return new Token[]{new Token<PsiNameIdentifierOwner>(parent, identifier.getText(), true, offset, SplitterFactory.getInstance().getIdentifierSplitter())};
    }
}

