/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.state;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.dictionary.AggregatedDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.spellchecker.state.CachedDictionaryState;
import com.intellij.spellchecker.state.ProjectDictionaryState;
import org.jetbrains.annotations.NotNull;

public class AggregatedDictionaryState {
    private ProjectDictionaryState projectDictionaryState;
    private CachedDictionaryState cachedDictionaryState;
    private AggregatedDictionary dictionary;
    private String currentUser;
    private Project project;

    public AggregatedDictionaryState() {
    }

    public AggregatedDictionaryState(@NotNull AggregatedDictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/state/AggregatedDictionaryState.<init> must not be null");
        }
        this.setDictionary(dictionary);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public void setDictionary(AggregatedDictionary dictionary) {
        this.dictionary = dictionary;
        this.cachedDictionaryState.setDictionary(dictionary.getCachedDictionary());
        this.projectDictionaryState.setProjectDictionary(dictionary.getProjectDictionary());
    }

    public AggregatedDictionary getDictionary() {
        return this.dictionary;
    }

    public void loadState() {
        assert (this.project != null);
        this.cachedDictionaryState = (CachedDictionaryState)ServiceManager.getService((Project)this.project, CachedDictionaryState.class);
        this.projectDictionaryState = (ProjectDictionaryState)ServiceManager.getService((Project)this.project, ProjectDictionaryState.class);
        this.currentUser = System.getProperty("user.name");
        this.retrieveDictionaries();
    }

    private void retrieveDictionaries() {
        ProjectDictionary projectDictionary = this.projectDictionaryState.getProjectDictionary();
        projectDictionary.setActiveName(this.currentUser);
        if (this.cachedDictionaryState.getDictionary() == null) {
            this.cachedDictionaryState.setDictionary(new UserDictionary("cached"));
        }
        this.dictionary = new AggregatedDictionary(projectDictionary, this.cachedDictionaryState.getDictionary());
        this.setDictionary(this.dictionary);
    }

    public String toString() {
        return "AggregatedDictionaryState{dictionary=" + this.dictionary + '}';
    }
}

