/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.spellchecker.quickfixes.DictionarySuggestionProvider;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTo
extends ShowSuggestions
implements SpellCheckerQuickFix {
    @NotNull
    public String getName() {
        String string = SpellCheckerBundle.message("rename.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/RenameTo.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpellCheckerBundle.message("rename.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/RenameTo.getFamilyName must not return null");
        }
        return string;
    }

    @Nullable
    private static DictionarySuggestionProvider findProvider() {
        Object[] extensions = Extensions.getExtensions((ExtensionPointName)NameSuggestionProvider.EP_NAME);
        if (extensions != null) {
            for (Object extension : extensions) {
                if (!(extension instanceof DictionarySuggestionProvider)) continue;
                return (DictionarySuggestionProvider)extension;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        Anchor anchor = Anchor.FIRST;
        if (anchor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/quickfixes/RenameTo.getPopupActionAnchor must not return null");
        }
        return anchor;
    }

    public void applyFix(final @NotNull Project project, final @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/quickfixes/RenameTo.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/quickfixes/RenameTo.applyFix must not be null");
        }
        Runnable fix = new Runnable(){

            @Override
            public void run() {
                DictionarySuggestionProvider provider = RenameTo.findProvider();
                if (provider != null) {
                    provider.setActive(true);
                }
                HashMap map = new HashMap();
                PsiElement psiElement = descriptor.getPsiElement();
                PsiFile containingFile = psiElement.getContainingFile();
                Editor editor = InjectedLanguageUtil.openEditorFor((PsiFile)containingFile, (Project)project);
                if (editor instanceof EditorWindow) {
                    map.put((Object)LangDataKeys.EDITOR.getName(), (Object)editor);
                    map.put((Object)LangDataKeys.PSI_ELEMENT.getName(), (Object)psiElement);
                } else if (ApplicationManager.getApplication().isUnitTestMode()) {
                    map.put((Object)LangDataKeys.PSI_ELEMENT.getName(), new TextEditorPsiDataProvider().getData(LangDataKeys.PSI_ELEMENT.getName(), editor, containingFile.getVirtualFile()));
                }
                DataContext dataContext = SimpleDataContext.getSimpleContext((Map)map, (DataContext)DataManager.getInstance().getDataContext());
                RenameElementAction action = new RenameElementAction();
                AnActionEvent event = new AnActionEvent(null, dataContext, "", action.getTemplatePresentation(), ActionManager.getInstance(), 0);
                action.actionPerformed(event);
                if (provider != null) {
                    provider.setActive(false);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            fix.run();
        } else {
            SwingUtilities.invokeLater(fix);
        }
    }
}

