/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.CheckArea;
import com.intellij.spellchecker.inspections.Splitter;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSplitter
implements Splitter {
    public static final int MIN_RANGE_LENGTH = 3;

    protected static void addWord(@NotNull String text, @NotNull List<CheckArea> results, boolean ignore, @Nullable TextRange found) {
        boolean tooShort;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.addWord must not be null");
        }
        if (results == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.addWord must not be null");
        }
        if (found == null || ignore) {
            return;
        }
        boolean bl = tooShort = found.getEndOffset() - found.getStartOffset() <= 3;
        if (tooShort) {
            return;
        }
        results.add(new CheckArea(text, found, false));
    }

    protected static boolean isAllWordsAreUpperCased(@NotNull String text, @NotNull List<TextRange> words) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.isAllWordsAreUpperCased must not be null");
        }
        if (words == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.isAllWordsAreUpperCased must not be null");
        }
        for (TextRange word : words) {
            StringCharacterIterator it = new StringCharacterIterator(text, word.getStartOffset(), word.getEndOffset(), word.getStartOffset());
            char c = it.first();
            while (c != '\uffff') {
                if (!Character.isUpperCase(c)) {
                    return false;
                }
                c = it.next();
            }
        }
        return true;
    }

    protected static boolean containsShortWord(@NotNull List<TextRange> words) {
        if (words == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.containsShortWord must not be null");
        }
        for (TextRange word : words) {
            if (word.getLength() >= 3) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range, @NotNull Matcher matcher) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.matcherRange must not be null");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.matcherRange must not be null");
        }
        TextRange textRange = BaseSplitter.subRange(range, matcher.start(), matcher.end());
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/inspections/BaseSplitter.matcherRange must not return null");
        }
        return textRange;
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range, @NotNull Matcher matcher, int group) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.matcherRange must not be null");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.matcherRange must not be null");
        }
        TextRange textRange = BaseSplitter.subRange(range, matcher.start(group), matcher.end(group));
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/inspections/BaseSplitter.matcherRange must not return null");
        }
        return textRange;
    }

    @NotNull
    protected static TextRange subRange(@NotNull TextRange range, int start, int end) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.subRange must not be null");
        }
        TextRange textRange = TextRange.from((int)(range.getStartOffset() + start), (int)(end - start));
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/inspections/BaseSplitter.subRange must not return null");
        }
        return textRange;
    }

    @Override
    public List<CheckArea> split(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return this.split(text, new TextRange(0, text.length()));
    }

    protected static boolean tooSmall(int from, int till) {
        return till - from <= 3;
    }

    @Nullable
    protected static List<TextRange> excludeByPattern(String text, TextRange range, @NotNull Pattern toExclude, int groupToInclude) {
        int till;
        if (toExclude == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/spellchecker/inspections/BaseSplitter.excludeByPattern must not be null");
        }
        ArrayList<TextRange> toCheck = new ArrayList<TextRange>();
        int from = range.getStartOffset();
        boolean addLast = true;
        Matcher matcher = toExclude.matcher(text.substring(range.getStartOffset(), range.getEndOffset()));
        while (matcher.find()) {
            TextRange contentFound;
            BaseSplitter.checkCancelled();
            TextRange found = BaseSplitter.matcherRange(range, matcher);
            till = found.getStartOffset() - 1;
            if (range.getEndOffset() - found.getEndOffset() < 3) {
                addLast = false;
            }
            if (!BaseSplitter.tooSmall(from, till)) {
                toCheck.add(new TextRange(from, till));
            }
            if (groupToInclude > 0 && BaseSplitter.tooSmall((contentFound = BaseSplitter.matcherRange(range, matcher, groupToInclude)).getEndOffset(), contentFound.getStartOffset())) {
                toCheck.add(new TextRange(contentFound.getStartOffset(), contentFound.getEndOffset()));
            }
            from = found.getEndOffset();
        }
        till = range.getEndOffset();
        if (BaseSplitter.tooSmall(from, till)) {
            return toCheck;
        }
        if (addLast) {
            toCheck.add(new TextRange(from, till));
        }
        return toCheck;
    }

    public static void checkCancelled() {
        ProgressManager.checkCanceled();
    }
}

