/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;

class ExpandBooleanPredicate
implements PsiElementPredicate {
    ExpandBooleanPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiStatement containingStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (containingStatement == null) {
            return false;
        }
        return ExpandBooleanPredicate.isBooleanReturn(containingStatement) || ExpandBooleanPredicate.isBooleanAssignment(containingStatement);
    }

    public static boolean isBooleanReturn(PsiStatement containingStatement) {
        if (!(containingStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)containingStatement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null || returnValue instanceof PsiLiteralExpression) {
            return false;
        }
        PsiType returnType = returnValue.getType();
        return PsiType.BOOLEAN.equals(returnType);
    }

    public static boolean isBooleanAssignment(PsiStatement containingStatement) {
        if (!(containingStatement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)containingStatement;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
        PsiExpression rhs = assignment.getRExpression();
        if (rhs == null || rhs instanceof PsiLiteralExpression) {
            return false;
        }
        PsiType assignmentType = rhs.getType();
        return PsiType.BOOLEAN.equals(assignmentType);
    }
}

