/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchtoif;

import com.intellij.psi.PsiStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class IfStatementBranch {
    private Set<String> m_topLevelVariables = new HashSet<String>(3);
    private Set<String> m_innerVariables = new HashSet<String>(3);
    private final LinkedList<String> comments = new LinkedList();
    private final LinkedList<String> statementComments = new LinkedList();
    private final List<String> m_conditions = new ArrayList<String>(3);
    private PsiStatement m_statement = null;
    private boolean m_else = false;

    public void addComment(String comment) {
        this.comments.addFirst(comment);
    }

    public void addStatementComment(String comment) {
        this.statementComments.addFirst(comment);
    }

    public void addCondition(String conditionString) {
        this.m_conditions.add(conditionString);
    }

    public void setStatement(PsiStatement statement) {
        this.m_statement = statement;
    }

    public PsiStatement getStatement() {
        return this.m_statement;
    }

    public List<String> getConditions() {
        return Collections.unmodifiableList(this.m_conditions);
    }

    public boolean isElse() {
        return this.m_else;
    }

    public void setElse() {
        this.m_else = true;
    }

    public void setTopLevelVariables(Set<String> topLevelVariables) {
        this.m_topLevelVariables = new HashSet<String>(topLevelVariables);
    }

    public void setInnerVariables(Set<String> innerVariables) {
        this.m_innerVariables = new HashSet<String>(innerVariables);
    }

    private Set<String> getTopLevelVariables() {
        return Collections.unmodifiableSet(this.m_topLevelVariables);
    }

    private Set<String> getInnerVariables() {
        return Collections.unmodifiableSet(this.m_innerVariables);
    }

    public boolean topLevelDeclarationsConfictWith(IfStatementBranch testBranch) {
        Set<String> innerVariables = testBranch.getInnerVariables();
        Set<String> topLevel = testBranch.getTopLevelVariables();
        return IfStatementBranch.hasNonEmptyIntersection(this.m_topLevelVariables, topLevel) || IfStatementBranch.hasNonEmptyIntersection(this.m_topLevelVariables, innerVariables);
    }

    private static boolean hasNonEmptyIntersection(Set<String> set1, Set<String> set2) {
        for (String set1Element : set1) {
            if (!set2.contains(set1Element)) continue;
            return true;
        }
        return false;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public List<String> getStatementComments() {
        return this.statementComments;
    }
}

