/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.psiutils.ComparisonUtils;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableAccessUtils {
    private VariableAccessUtils() {
    }

    public static boolean isVariableCompared(@NotNull PsiVariable variable, @Nullable PsiExpression expression) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/VariableAccessUtils.isVariableCompared must not be null");
        }
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!ComparisonUtils.isComparison(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        if (VariableAccessUtils.evaluatesToVariable(lhs, variable)) {
            return true;
        }
        return VariableAccessUtils.evaluatesToVariable(rhs, variable);
    }

    public static boolean isVariableIncrementOrDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/VariableAccessUtils.isVariableIncrementOrDecremented must not be null");
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            PsiJavaToken sign = prefixExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand = prefixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand, variable);
        }
        if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
            PsiJavaToken sign = postfixExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand = postfixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand, variable);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!VariableAccessUtils.evaluatesToVariable(lhs = ParenthesesUtils.stripParentheses(lhs), variable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = ParenthesesUtils.stripParentheses(rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                IElementType token = binaryExpression.getOperationTokenType();
                if (!token.equals(JavaTokenType.PLUS) && !token.equals(JavaTokenType.MINUS)) {
                    return false;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                lOperand = ParenthesesUtils.stripParentheses(lOperand);
                PsiExpression rOperand = binaryExpression.getROperand();
                if (VariableAccessUtils.evaluatesToVariable(rOperand = ParenthesesUtils.stripParentheses(rOperand), variable)) {
                    return true;
                }
                if (VariableAccessUtils.evaluatesToVariable(lOperand, variable)) {
                    return true;
                }
            } else if (tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ) {
                return true;
            }
        }
        return false;
    }

    public static boolean evaluatesToVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/psiutils/VariableAccessUtils.evaluatesToVariable must not be null");
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
        if (strippedExpression == null) {
            return false;
        }
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement referent = referenceExpression.resolve();
        return variable.equals(referent);
    }
}

