/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.IndexedForEachLoopPredicate;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ReplaceForEachLoopWithIndexedForLoopIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        IndexedForEachLoopPredicate indexedForEachLoopPredicate = new IndexedForEachLoopPredicate();
        if (indexedForEachLoopPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/forloop/ReplaceForEachLoopWithIndexedForLoopIntention.getElementPredicate must not return null");
        }
        return indexedForEachLoopPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        String iteratedValueText;
        String variableNameRoot;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/forloop/ReplaceForEachLoopWithIndexedForLoopIntention.processIntention must not be null");
        }
        PsiForeachStatement statement = (PsiForeachStatement)element.getParent();
        if (statement == null) {
            return;
        }
        PsiExpression iteratedValue = ParenthesesUtils.stripParentheses(statement.getIteratedValue());
        if (iteratedValue == null) {
            return;
        }
        PsiParameter iterationParameter = statement.getIterationParameter();
        PsiType type = iterationParameter.getType();
        PsiType iteratedValueType = iteratedValue.getType();
        if (iteratedValueType == null) {
            return;
        }
        boolean isArray = iteratedValueType instanceof PsiArrayType;
        Project project = statement.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        String indexText = codeStyleManager.suggestUniqueVariableName("i", (PsiElement)statement, true);
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        if (iteratedValue instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)iteratedValue;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (name == null) {
                return;
            }
            variableNameRoot = name.startsWith("to") && name.length() > 2 ? StringUtil.decapitalize((String)name.substring(2)) : (name.startsWith("get") && name.length() > 3 ? StringUtil.decapitalize((String)name.substring(3)) : name);
            String variableName = codeStyleManager.suggestUniqueVariableName(variableNameRoot, (PsiElement)statement, true);
            StringBuilder declaration = new StringBuilder();
            if (codeStyleSettings.GENERATE_FINAL_LOCALS) {
                declaration.append("final ");
            }
            declaration.append(iteratedValueType.getCanonicalText());
            declaration.append(' ');
            declaration.append(variableName);
            declaration.append('=');
            declaration.append(iteratedValue.getText());
            declaration.append(';');
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiStatement declarationStatement = elementFactory.createStatementFromText(declaration.toString(), (PsiElement)statement);
            statement.getParent().addBefore((PsiElement)declarationStatement, (PsiElement)statement);
            iteratedValueText = variableName;
        } else if (iteratedValue instanceof PsiTypeCastExpression) {
            iteratedValueText = iteratedValue.getText();
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)iteratedValue;
            PsiExpression operand = castExpression.getOperand();
            PsiExpression strippedOperand = ParenthesesUtils.stripParentheses(operand);
            variableNameRoot = strippedOperand == null ? "" : strippedOperand.getText();
        } else if (iteratedValue instanceof PsiJavaCodeReferenceElement) {
            iteratedValueText = iteratedValue.getText();
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)iteratedValue;
            String referenceName = referenceElement.getReferenceName();
            variableNameRoot = referenceName == null ? iteratedValueText : referenceName;
        } else {
            variableNameRoot = iteratedValueText = iteratedValue.getText();
        }
        String lengthText = isArray ? codeStyleManager.suggestUniqueVariableName(variableNameRoot + "Length", (PsiElement)statement, true) : codeStyleManager.suggestUniqueVariableName(variableNameRoot + "Size", (PsiElement)statement, true);
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("for(int ");
        newStatement.append(indexText);
        newStatement.append(" = 0, ");
        newStatement.append(lengthText);
        newStatement.append(" = ");
        if (iteratedValue instanceof PsiTypeCastExpression) {
            newStatement.append('(');
            newStatement.append(iteratedValueText);
            newStatement.append(')');
        } else {
            newStatement.append(iteratedValueText);
        }
        if (isArray) {
            newStatement.append(".length;");
        } else {
            newStatement.append(".size();");
        }
        newStatement.append(indexText);
        newStatement.append('<');
        newStatement.append(lengthText);
        newStatement.append(';');
        newStatement.append(indexText);
        newStatement.append("++)");
        newStatement.append("{ ");
        if (codeStyleSettings.GENERATE_FINAL_LOCALS) {
            newStatement.append("final ");
        }
        newStatement.append(type.getCanonicalText());
        newStatement.append(' ');
        newStatement.append(iterationParameter.getName());
        newStatement.append(" = ");
        if (iteratedValue instanceof PsiTypeCastExpression) {
            newStatement.append('(');
            newStatement.append(iteratedValueText);
            newStatement.append(')');
        } else {
            newStatement.append(iteratedValueText);
        }
        if (isArray) {
            newStatement.append('[');
            newStatement.append(indexText);
            newStatement.append("];");
        } else {
            newStatement.append(".get(");
            newStatement.append(indexText);
            newStatement.append(");");
        }
        PsiStatement body = statement.getBody();
        if (body == null) {
            return;
        }
        if (body instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)body).getCodeBlock();
            PsiElement[] children = block.getChildren();
            for (int i = 1; i < children.length - 1; ++i) {
                newStatement.append(children[i].getText());
            }
        } else {
            newStatement.append(body.getText());
        }
        newStatement.append('}');
        ReplaceForEachLoopWithIndexedForLoopIntention.replaceStatementAndShorten(newStatement.toString(), (PsiStatement)statement);
    }
}

