/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.constant.ConstantSubexpressionPredicate;
import com.siyeh.ipp.psiutils.ConcatenationUtils;
import com.siyeh.ipp.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantSubexpressionIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConstantSubexpressionPredicate constantSubexpressionPredicate = new ConstantSubexpressionPredicate();
        if (constantSubexpressionPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/constant/ConstantSubexpressionIntention.getElementPredicate must not return null");
        }
        return constantSubexpressionPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiExpression leftSide;
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element.getParent();
        assert (binaryExpression != null);
        PsiExpression lhs = binaryExpression.getLOperand();
        if (lhs instanceof PsiBinaryExpression) {
            PsiBinaryExpression lhsBinaryExpression = (PsiBinaryExpression)lhs;
            leftSide = lhsBinaryExpression.getROperand();
        } else {
            leftSide = lhs;
        }
        PsiJavaToken operationSign = binaryExpression.getOperationSign();
        PsiExpression rhs = binaryExpression.getROperand();
        assert (rhs != null);
        assert (leftSide != null);
        return IntentionPowerPackBundle.message("constant.subexpression.intention.name", leftSide.getText() + ' ' + operationSign.getText() + ' ' + rhs.getText());
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        Object constantValue;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/constant/ConstantSubexpressionIntention.processIntention must not be null");
        }
        PsiExpression expression = (PsiExpression)element.getParent();
        assert (expression != null);
        String newExpression = "";
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression copy = (PsiBinaryExpression)expression.copy();
            PsiExpression lhs = copy.getLOperand();
            if (lhs instanceof PsiBinaryExpression) {
                PsiBinaryExpression lhsBinaryExpression = (PsiBinaryExpression)lhs;
                newExpression = newExpression + ConstantSubexpressionIntention.getLeftSideText(lhsBinaryExpression);
                PsiExpression rightSide = lhsBinaryExpression.getROperand();
                assert (rightSide != null);
                lhs.replace((PsiElement)rightSide);
            }
            constantValue = ConcatenationUtils.isConcatenation((PsiElement)expression) ? ConstantSubexpressionIntention.computeConstantStringExpression(copy) : ExpressionUtils.computeConstantExpression((PsiExpression)copy);
        } else {
            constantValue = ExpressionUtils.computeConstantExpression(expression);
        }
        if (constantValue instanceof String) {
            newExpression = newExpression + '\"' + StringUtil.escapeStringCharacters((String)constantValue.toString()) + '\"';
        } else if (constantValue != null) {
            Number number;
            if (constantValue instanceof Number && 0.0 > (number = (Number)constantValue).doubleValue()) {
                newExpression = newExpression + " ";
            }
            newExpression = newExpression + constantValue.toString();
        }
        ConstantSubexpressionIntention.replaceExpression(newExpression, expression);
    }

    private static String computeConstantStringExpression(PsiBinaryExpression expression) {
        PsiExpression lhs = expression.getLOperand();
        String lhsText = lhs.getText();
        String result = lhsText.charAt(0) == '\'' || lhsText.charAt(0) == '\"' ? lhsText.substring(1, lhsText.length() - 1) : lhsText;
        PsiExpression rhs = expression.getROperand();
        assert (rhs != null);
        String rhsText = rhs.getText();
        result = rhsText.charAt(0) == '\'' || rhsText.charAt(0) == '\"' ? result + rhsText.substring(1, rhsText.length() - 1) : result + rhsText;
        return result;
    }

    private static String getLeftSideText(PsiBinaryExpression binaryExpression) {
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiJavaToken sign = binaryExpression.getOperationSign();
        return lhs.getText() + sign.getText();
    }
}

