/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.constant.ConstantExpressionPredicate;
import com.siyeh.ipp.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantExpressionIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConstantExpressionPredicate constantExpressionPredicate = new ConstantExpressionPredicate();
        if (constantExpressionPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/constant/ConstantExpressionIntention.getElementPredicate must not return null");
        }
        return constantExpressionPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        String newExpression;
        PsiExpression expression = (PsiExpression)element;
        Object value = ExpressionUtils.computeConstantExpression(expression);
        if (value instanceof String) {
            String string = (String)value;
            newExpression = '\"' + StringUtil.escapeStringCharacters((String)string) + '\"';
        } else {
            double v;
            newExpression = value instanceof Character ? '\'' + StringUtil.escapeStringCharacters((String)value.toString()) + '\'' : (value instanceof Long ? value.toString() + 'L' : (value instanceof Double ? (Double.isNaN(v = ((Double)value).doubleValue()) ? "java.lang.Double.NaN" : (Double.isInfinite(v) ? (v > 0.0 ? "java.lang.Double.POSITIVE_INFINITY" : "java.lang.Double.NEGATIVE_INFINITY") : Double.toString(v))) : (value instanceof Float ? (Float.isNaN(v = ((Float)value).floatValue()) ? "java.lang.Float.NaN" : (Float.isInfinite(v) ? (v > 0.0f ? "java.lang.Float.POSITIVE_INFINITY" : "java.lang.Float.NEGATIVE_INFINITY") : Float.toString(v) + 'f')) : (value == null ? "null" : String.valueOf(value)))));
        }
        ConstantExpressionIntention.replaceExpression(newExpression, expression);
    }
}

