/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.SimpleStringConcatenationPredicate;
import com.siyeh.ipp.psiutils.ConcatenationUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReplaceConcatenationWithFormatStringIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        SimpleStringConcatenationPredicate simpleStringConcatenationPredicate = new SimpleStringConcatenationPredicate();
        if (simpleStringConcatenationPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/concatenation/ReplaceConcatenationWithFormatStringIntention.getElementPredicate must not return null");
        }
        return simpleStringConcatenationPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/concatenation/ReplaceConcatenationWithFormatStringIntention.processIntention must not be null");
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        PsiElement parent = expression.getParent();
        while (ConcatenationUtils.isConcatenation(parent)) {
            expression = (PsiBinaryExpression)parent;
            if (expression == null) {
                return;
            }
            parent = expression.getParent();
        }
        StringBuilder formatString = new StringBuilder();
        ArrayList<PsiExpression> formatParameters = new ArrayList<PsiExpression>();
        this.buildFormatString(expression, formatString, formatParameters);
        if (ReplaceConcatenationWithFormatStringIntention.replaceWithPrintfExpression(expression, formatString, formatParameters)) {
            return;
        }
        StringBuilder newExpression = new StringBuilder();
        newExpression.append("java.lang.String.format(\"");
        newExpression.append((CharSequence)formatString);
        newExpression.append('\"');
        for (PsiExpression formatParameter : formatParameters) {
            newExpression.append(", ");
            newExpression.append(formatParameter.getText());
        }
        newExpression.append(')');
        ReplaceConcatenationWithFormatStringIntention.replaceExpression(newExpression.toString(), (PsiExpression)expression);
    }

    private static boolean replaceWithPrintfExpression(PsiBinaryExpression expression, CharSequence formatString, List<PsiExpression> formatParameters) throws IncorrectOperationException {
        boolean insertNewline;
        PsiElement expressionParent = expression.getParent();
        if (!(expressionParent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandParent = expressionParent.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if ("println".equals(name)) {
            insertNewline = true;
        } else if ("print".equals(name)) {
            insertNewline = false;
        } else {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (!"java.io.PrintStream".equals(qualifiedName) && !"java.io.Printwriter".equals(qualifiedName)) {
            return false;
        }
        StringBuilder newExpression = new StringBuilder();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null) {
            newExpression.append(qualifier.getText());
            newExpression.append('.');
        }
        newExpression.append("printf(\"");
        newExpression.append(formatString);
        if (insertNewline) {
            newExpression.append("%n");
        }
        newExpression.append('\"');
        for (PsiExpression formatParameter : formatParameters) {
            newExpression.append(", ");
            newExpression.append(formatParameter.getText());
        }
        newExpression.append(')');
        ReplaceConcatenationWithFormatStringIntention.replaceExpression(newExpression.toString(), (PsiExpression)methodCallExpression);
        return true;
    }

    void buildFormatString(PsiBinaryExpression expression, StringBuilder formatString, List<PsiExpression> formatParameters) {
        PsiExpression lhs = expression.getLOperand();
        this.appendFormatString(lhs, formatString, formatParameters);
        PsiExpression rhs = expression.getROperand();
        if (rhs != null) {
            this.appendFormatString(rhs, formatString, formatParameters);
        }
    }

    private void appendFormatString(PsiExpression lhs, StringBuilder formatString, List<PsiExpression> formatParameters) {
        if (lhs instanceof PsiLiteralExpression) {
            String text = lhs.getText();
            int length = text.length();
            PsiType type = lhs.getType();
            if (type != null && (type.equalsToText("java.lang.String") || type.equalsToText("char"))) {
                if (length > 2) {
                    formatString.append(text.substring(1, length - 1));
                }
            } else {
                formatString.append(text);
            }
        } else if (lhs instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)lhs;
            this.buildFormatString(binaryExpression, formatString, formatParameters);
        } else {
            PsiType type = lhs.getType();
            if (type != null && (type.equalsToText("long") || type.equalsToText("int") || type.equalsToText("java.lang.Long") || type.equalsToText("java.lang.Integer"))) {
                formatString.append("%d");
            } else {
                formatString.append("%s");
            }
            formatParameters.add(lhs);
        }
    }
}

