/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.TreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CommentOnLineWithSourcePredicate
implements PsiElementPredicate {
    CommentOnLineWithSourcePredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        if (element instanceof PsiDocComment) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        if (comment instanceof PsiLanguageInjectionHost && CommentOnLineWithSourcePredicate.containsInjectedPsi((PsiLanguageInjectionHost)comment)) {
            return false;
        }
        IElementType type = comment.getTokenType();
        if (!JavaTokenType.C_STYLE_COMMENT.equals(type) && !JavaTokenType.END_OF_LINE_COMMENT.equals(type)) {
            return false;
        }
        PsiElement prevSibling = TreeUtil.getPrevLeaf(element);
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return true;
        }
        String prevSiblingText = prevSibling.getText();
        if (prevSiblingText.indexOf(10) < 0 && prevSiblingText.indexOf(13) < 0) {
            return true;
        }
        PsiElement nextSibling = TreeUtil.getNextLeaf(element);
        if (!(nextSibling instanceof PsiWhiteSpace)) {
            return true;
        }
        String nextSiblingText = nextSibling.getText();
        return nextSiblingText.indexOf(10) < 0 && nextSiblingText.indexOf(13) < 0;
    }

    private static boolean containsInjectedPsi(PsiLanguageInjectionHost injectionHost) {
        final Ref containsInjected = Ref.create((Object)false);
        injectionHost.processInjectedPsi(new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/comment/CommentOnLineWithSourcePredicate$1.visit must not be null");
                }
                if (places == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/comment/CommentOnLineWithSourcePredicate$1.visit must not be null");
                }
                containsInjected.set((Object)true);
            }
        });
        return (Boolean)containsInjected.get();
    }
}

