/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ComparisonPredicate;
import com.siyeh.ipp.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class NegateComparisonIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        String operatorText = "";
        String negatedOperatorText = "";
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        if (exp != null) {
            PsiJavaToken sign = exp.getOperationSign();
            operatorText = sign.getText();
            negatedOperatorText = ComparisonUtils.getNegatedComparison(sign);
        }
        if (operatorText.equals(negatedOperatorText)) {
            return IntentionPowerPackBundle.message("negate.comparison.intention.name", operatorText);
        }
        return IntentionPowerPackBundle.message("negate.comparison.intention.name1", operatorText, negatedOperatorText);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ComparisonPredicate comparisonPredicate = new ComparisonPredicate();
        if (comparisonPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/bool/NegateComparisonIntention.getElementPredicate must not return null");
        }
        return comparisonPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        PsiExpression lhs = expression.getLOperand();
        PsiExpression rhs = expression.getROperand();
        PsiJavaToken sign = expression.getOperationSign();
        String negatedOperator = ComparisonUtils.getNegatedComparison(sign);
        String lhsText = lhs.getText();
        assert (rhs != null);
        String rhsText = rhs.getText();
        NegateComparisonIntention.replaceExpressionWithNegatedExpressionString(lhsText + negatedOperator + rhsText, (PsiExpression)expression);
    }
}

