/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.ui.ImageComponent;
import org.intellij.images.vfs.IfsUtil;

final class ImageEditorImpl
extends VirtualFileAdapter
implements ImageEditor {
    private final PropertyChangeListener optionsChangeListener = new OptionsChangeListener();
    private final Project project;
    private final VirtualFile file;
    private final ImageEditorUI editorUI;
    private boolean disposed;

    ImageEditorImpl(Project project, VirtualFile file) {
        this.project = project;
        this.file = file;
        Options options = OptionsManager.getInstance().getOptions();
        this.editorUI = new ImageEditorUI(this, options.getEditorOptions());
        options.addPropertyChangeListener(this.optionsChangeListener);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this);
        this.setValue(file);
    }

    private void setValue(VirtualFile file) {
        ImageDocument document = this.editorUI.getImageComponent().getDocument();
        try {
            BufferedImage previousImage = document.getValue();
            BufferedImage image = IfsUtil.getImage(file);
            document.setValue(image);
            document.setFormat(IfsUtil.getFormat(file));
            ImageZoomModel zoomModel = this.getZoomModel();
            if (!(image == null || previousImage != null && zoomModel.isZoomLevelChanged())) {
                Options options = OptionsManager.getInstance().getOptions();
                ZoomOptions zoomOptions = options.getEditorOptions().getZoomOptions();
                zoomModel.setZoomFactor(1.0);
                if (zoomOptions.isSmartZooming()) {
                    Dimension prefferedSize = zoomOptions.getPrefferedSize();
                    if (prefferedSize.width > image.getWidth() && prefferedSize.height > image.getHeight()) {
                        double factor = (prefferedSize.getWidth() / (double)image.getWidth() + prefferedSize.getHeight() / (double)image.getHeight()) / 2.0;
                        zoomModel.setZoomFactor(Math.ceil(factor));
                    }
                }
            }
        }
        catch (Exception e) {
            document.setValue(null);
        }
    }

    @Override
    public boolean isValid() {
        ImageDocument document = this.editorUI.getImageComponent().getDocument();
        return document.getValue() != null;
    }

    @Override
    public JComponent getComponent() {
        return this.editorUI;
    }

    @Override
    public JComponent getContentComponent() {
        return this.editorUI.getImageComponent();
    }

    @Override
    public VirtualFile getFile() {
        return this.file;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public ImageDocument getDocument() {
        return this.editorUI.getImageComponent().getDocument();
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        this.editorUI.getImageComponent().setTransparencyChessboardVisible(visible);
        this.editorUI.repaint();
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.editorUI.getImageComponent().isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return !"Images.Thumbnails".equals(place);
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.editorUI.getImageComponent().setGridVisible(visible);
        this.editorUI.repaint();
    }

    @Override
    public boolean isGridVisible() {
        return this.editorUI.getImageComponent().isGridVisible();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public ImageZoomModel getZoomModel() {
        return this.editorUI.getZoomModel();
    }

    public void dispose() {
        Options options = OptionsManager.getInstance().getOptions();
        options.removePropertyChangeListener(this.optionsChangeListener);
        this.editorUI.dispose();
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this);
        this.disposed = true;
    }

    public void propertyChanged(VirtualFilePropertyEvent event) {
        super.propertyChanged(event);
        if (this.file.equals(event.getFile())) {
            this.file.refresh(true, false, new Runnable(){

                @Override
                public void run() {
                    if (ImageFileTypeManager.getInstance().isImage(ImageEditorImpl.this.file)) {
                        ImageEditorImpl.this.setValue(ImageEditorImpl.this.file);
                    } else {
                        ImageEditorImpl.this.setValue(null);
                        FileEditorManager editorManager = FileEditorManager.getInstance((Project)ImageEditorImpl.this.project);
                        editorManager.closeFile(ImageEditorImpl.this.file);
                    }
                }
            });
        }
    }

    public void contentsChanged(VirtualFileEvent event) {
        super.contentsChanged(event);
        if (this.file.equals(event.getFile())) {
            this.file.refresh(true, false, new Runnable(){

                @Override
                public void run() {
                    ImageEditorImpl.this.setValue(ImageEditorImpl.this.file);
                }
            });
        }
    }

    private class OptionsChangeListener
    implements PropertyChangeListener {
        private OptionsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Options options = (Options)evt.getSource();
            EditorOptions editorOptions = options.getEditorOptions();
            TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
            GridOptions gridOptions = editorOptions.getGridOptions();
            ImageComponent imageComponent = ImageEditorImpl.this.editorUI.getImageComponent();
            imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
            imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
            imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
            imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
            imageComponent.setGridLineSpan(gridOptions.getLineSpan());
            imageComponent.setGridLineColor(gridOptions.getLineColor());
        }
    }
}

