/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdReferenceProvider;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlDeclareIdInCommentAction;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlRefCountHolder {
    private static final Key<CachedValue<XmlRefCountHolder>> xmlRefCountHolderKey = Key.create((String)"xml ref count holder");
    private static final UserDataCache<CachedValue<XmlRefCountHolder>, XmlFile, Object> CACHE = new UserDataCache<CachedValue<XmlRefCountHolder>, XmlFile, Object>(){

        protected CachedValue<XmlRefCountHolder> compute(final XmlFile file, Object p) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlRefCountHolder>(){

                public CachedValueProvider.Result<XmlRefCountHolder> compute() {
                    XmlRefCountHolder holder = new XmlRefCountHolder();
                    Language language = file.getViewProvider().getBaseLanguage();
                    PsiFile psiFile = file.getViewProvider().getPsi(language);
                    psiFile.accept((PsiElementVisitor)new IdGatheringRecursiveVisitor(holder));
                    return new CachedValueProvider.Result((Object)holder, new Object[]{file});
                }
            }, false);
        }
    };
    private final Map<String, List<Pair<XmlAttributeValue, Boolean>>> myId2AttributeListMap = new HashMap<String, List<Pair<XmlAttributeValue, Boolean>>>();
    private final Set<XmlAttributeValue> myPossiblyDuplicateIds = new HashSet<XmlAttributeValue>();
    private final List<XmlAttributeValue> myIdReferences = new ArrayList<XmlAttributeValue>();
    private final Set<String> myAdditionallyDeclaredIds = new HashSet<String>();
    private final Set<PsiElement> myDoNotValidateParentsList = new HashSet<PsiElement>();

    public static XmlRefCountHolder getInstance(XmlFile file) {
        return (XmlRefCountHolder)((CachedValue)CACHE.get(xmlRefCountHolderKey, (Object)file, null)).getValue();
    }

    private XmlRefCountHolder() {
    }

    public boolean isDuplicateIdAttributeValue(@NotNull XmlAttributeValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder.isDuplicateIdAttributeValue must not be null");
        }
        return this.myPossiblyDuplicateIds.contains(value);
    }

    public boolean isValidatable(@Nullable PsiElement element) {
        return !this.myDoNotValidateParentsList.contains(element);
    }

    public boolean hasIdDeclaration(@NotNull String idRef) {
        if (idRef == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder.hasIdDeclaration must not be null");
        }
        return this.myId2AttributeListMap.get(idRef) != null || this.myAdditionallyDeclaredIds.contains(idRef);
    }

    public boolean isIdReferenceValue(@NotNull XmlAttributeValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder.isIdReferenceValue must not be null");
        }
        return this.myIdReferences.contains(value);
    }

    private void registerId(@NotNull String id, @NotNull XmlAttributeValue attributeValue, boolean soft) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder.registerId must not be null");
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder.registerId must not be null");
        }
        List<Pair<XmlAttributeValue, Boolean>> list = this.myId2AttributeListMap.get(id);
        if (list == null) {
            list = new ArrayList<Pair<XmlAttributeValue, Boolean>>();
            this.myId2AttributeListMap.put(id, list);
        } else if (!soft) {
            if (list.size() == 1) {
                if (!((Boolean)list.get((int)0).second).booleanValue()) {
                    this.myPossiblyDuplicateIds.add((XmlAttributeValue)list.get((int)0).first);
                    this.myPossiblyDuplicateIds.add(attributeValue);
                }
            } else {
                this.myPossiblyDuplicateIds.add(attributeValue);
            }
        }
        list.add((Pair<XmlAttributeValue, Boolean>)new Pair((Object)attributeValue, (Object)soft));
    }

    private void registerAdditionalId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder.registerAdditionalId must not be null");
        }
        this.myAdditionallyDeclaredIds.add(id);
    }

    private void registerIdReference(@NotNull XmlAttributeValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder.registerIdReference must not be null");
        }
        this.myIdReferences.add(value);
    }

    private void registerOuterLanguageElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder.registerOuterLanguageElement must not be null");
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlText) {
            parent = parent.getParent();
        }
        this.myDoNotValidateParentsList.add(parent);
    }

    private static class IdGatheringRecursiveVisitor
    extends XmlRecursiveElementVisitor {
        private final XmlRefCountHolder myHolder;

        private IdGatheringRecursiveVisitor(@NotNull XmlRefCountHolder holder) {
            if (holder == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder$IdGatheringRecursiveVisitor.<init> must not be null");
            }
            super(true);
            this.myHolder = holder;
        }

        public void visitElement(PsiElement element) {
            if (element instanceof OuterLanguageElement) {
                this.visitOuterLanguageElement(element);
            }
            super.visitElement(element);
        }

        private void visitOuterLanguageElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder$IdGatheringRecursiveVisitor.visitOuterLanguageElement must not be null");
            }
            this.myHolder.registerOuterLanguageElement(element);
        }

        public void visitComment(PsiComment comment) {
            this.doVisitAnyComment(comment);
            super.visitComment(comment);
        }

        public void visitXmlComment(XmlComment comment) {
            this.doVisitAnyComment((PsiComment)comment);
            super.visitXmlComment(comment);
        }

        private void doVisitAnyComment(PsiComment comment) {
            String id = XmlDeclareIdInCommentAction.getImplicitlyDeclaredId(comment);
            if (id != null) {
                this.myHolder.registerAdditionalId(id);
            }
        }

        public void visitXmlAttributeValue(XmlAttributeValue value) {
            PsiElement element = value.getParent();
            if (!(element instanceof XmlAttribute)) {
                return;
            }
            XmlAttribute attribute = (XmlAttribute)element;
            XmlTag tag = attribute.getParent();
            if (tag == null) {
                return;
            }
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (descriptor == null) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = descriptor.getAttributeDescriptor(attribute);
            if (attributeDescriptor == null) {
                return;
            }
            if (attributeDescriptor.hasIdType()) {
                this.updateMap(attribute, value, false);
            } else {
                PsiReference[] references;
                for (PsiReference r : references = value.getReferences()) {
                    if (!(r instanceof IdReferenceProvider.GlobalAttributeValueSelfReference)) continue;
                    this.updateMap(attribute, value, r.isSoft());
                }
            }
            if (attributeDescriptor.hasIdRefType() && PsiTreeUtil.getChildOfType((PsiElement)value, OuterLanguageElement.class) == null) {
                this.myHolder.registerIdReference(value);
            }
            super.visitXmlAttributeValue(value);
        }

        private void updateMap(@NotNull XmlAttribute attribute, @NotNull XmlAttributeValue value, boolean soft) {
            if (attribute == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder$IdGatheringRecursiveVisitor.updateMap must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/util/XmlRefCountHolder$IdGatheringRecursiveVisitor.updateMap must not be null");
            }
            String id = XmlHighlightVisitor.getUnquotedValue(value, attribute.getParent());
            if (XmlUtil.isSimpleXmlAttributeValue(id, value) && PsiTreeUtil.getChildOfType((PsiElement)value, OuterLanguageElement.class) == null) {
                this.myHolder.registerId(id, value, soft);
            }
        }
    }
}

