/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.NamedObjectDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeDescriptorImpl
extends BasicXmlAttributeDescriptor
implements PsiWritableMetaData {
    private XmlTag myTag;
    String myUse;
    @NonNls
    public static final String REQUIRED_ATTR_VALUE = "required";
    @NonNls
    public static final String QUALIFIED_ATTR_VALUE = "qualified";

    public XmlAttributeDescriptorImpl(XmlTag tag) {
        this.myTag = tag;
        this.myUse = this.myTag.getAttributeValue("use");
    }

    public XmlAttributeDescriptorImpl() {
    }

    public PsiElement getDeclaration() {
        return this.myTag;
    }

    public String getName() {
        return this.myTag.getAttributeValue("name");
    }

    public void init(PsiElement element) {
        this.myTag = (XmlTag)element;
        this.myUse = this.myTag.getAttributeValue("use");
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isRequired() {
        return REQUIRED_ATTR_VALUE.equals(this.myUse);
    }

    public boolean isFixed() {
        return this.myTag.getAttributeValue("fixed") != null;
    }

    private boolean hasSimpleSchemaType(@NonNls String type) {
        String attributeValue = this.myTag.getAttributeValue("type");
        if (attributeValue != null && attributeValue.endsWith(type)) {
            String namespacePrefix = this.myTag.getNamespacePrefix();
            if (namespacePrefix.length() > 0) {
                return attributeValue.equals(namespacePrefix + ":" + type);
            }
            return attributeValue.equals(type);
        }
        return false;
    }

    public boolean hasIdType() {
        return this.hasSimpleSchemaType("ID");
    }

    public boolean hasIdRefType() {
        return this.hasSimpleSchemaType("IDREF");
    }

    public String getDefaultValue() {
        if (this.isFixed()) {
            return this.myTag.getAttributeValue("fixed");
        }
        return this.myTag.getAttributeValue("default");
    }

    @Override
    public boolean isEnumerated(@Nullable XmlElement context) {
        XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)XmlUtil.findXmlDescriptorByType(this.myTag, context != null ? (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)context, XmlTag.class, (boolean)true) : null);
        if (elementDescriptor != null && elementDescriptor.getType() instanceof ComplexTypeDescriptor) {
            EnumerationData data = XmlAttributeDescriptorImpl.getEnumeratedValuesImpl(((ComplexTypeDescriptor)elementDescriptor.getType()).getDeclaration());
            return data != null && data.exaustive;
        }
        return false;
    }

    public boolean isEnumerated() {
        return this.isEnumerated(null);
    }

    public String[] getEnumeratedValues() {
        return this.getEnumeratedValues(null);
    }

    @Override
    public String[] getEnumeratedValues(XmlElement context) {
        XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)XmlUtil.findXmlDescriptorByType(this.myTag, context != null ? (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)context, XmlTag.class, (boolean)true) : null);
        if (elementDescriptor != null && elementDescriptor.getType() instanceof ComplexTypeDescriptor) {
            EnumerationData data = XmlAttributeDescriptorImpl.getEnumeratedValuesImpl(((ComplexTypeDescriptor)elementDescriptor.getType()).getDeclaration());
            String s = this.getDefaultValue();
            if (s != null && s.length() > 0 && data == null) {
                return new String[]{s};
            }
            return data != null ? data.enumeratedValues : ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String namespacePrefix = this.myTag.getNamespacePrefix();
        XmlTag type = this.myTag.findFirstSubTag((namespacePrefix.length() > 0 ? namespacePrefix + ":" : "") + "simpleType");
        if (type != null) {
            EnumerationData data = XmlAttributeDescriptorImpl.getEnumeratedValuesImpl(type);
            return data != null ? data.enumeratedValues : ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    private static EnumerationData getEnumeratedValuesImpl(XmlTag declaration) {
        if ("boolean".equals(declaration.getAttributeValue("name"))) {
            return new EnumerationData(new String[]{"true", "false"}, true);
        }
        HashSet<String> variants = new HashSet<String>();
        boolean exaustive = XmlUtil.collectEnumerationValues(declaration, variants);
        if (variants.size() > 0) {
            return new EnumerationData(ArrayUtil.toStringArray(variants), exaustive);
        }
        return null;
    }

    @Override
    public String getName(PsiElement context) {
        String prefixByNamespace;
        XmlElementDescriptor xmlElementDescriptor;
        String form = this.myTag.getAttributeValue("form");
        boolean isQualifiedAttr = QUALIFIED_ATTR_VALUE.equals(form);
        XmlTag rootTag = ((XmlFile)this.myTag.getContainingFile()).getDocument().getRootTag();
        String targetNs = rootTag.getAttributeValue("targetNamespace");
        XmlTag contextTag = (XmlTag)context;
        String name = this.getName();
        boolean attributeShouldBeQualified = false;
        String contextNs = contextTag.getNamespace();
        if (targetNs != null && !contextNs.equals(targetNs) && (xmlElementDescriptor = contextTag.getDescriptor()) instanceof XmlElementDescriptorImpl) {
            XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)xmlElementDescriptor;
            TypeDescriptor type = elementDescriptor.getType();
            if (type instanceof ComplexTypeDescriptor) {
                ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
                boolean bl = attributeShouldBeQualified = typeDescriptor.canContainAttribute(name, targetNs) != ComplexTypeDescriptor.CanContainAttributeType.CanNotContain;
            }
            if (!attributeShouldBeQualified && contextNs.length() == 0 && targetNs.length() > 0) {
                boolean bl = attributeShouldBeQualified = !targetNs.equals(elementDescriptor.getNamespace());
            }
        }
        if (targetNs != null && (isQualifiedAttr || QUALIFIED_ATTR_VALUE.equals(rootTag.getAttributeValue("attributeFormDefault")) || attributeShouldBeQualified) && (prefixByNamespace = contextTag.getPrefixByNamespace(targetNs)) != null && prefixByNamespace.length() > 0) {
            name = prefixByNamespace + ":" + name;
        }
        return name;
    }

    public void setName(String name) throws IncorrectOperationException {
        NamedObjectDescriptor.setName(this.myTag, name);
    }

    static class EnumerationData {
        final String[] enumeratedValues;
        final boolean exaustive;

        EnumerationData(@NotNull String[] _values, boolean _exaustive) {
            if (_values == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/schema/XmlAttributeDescriptorImpl$EnumerationData.<init> must not be null");
            }
            this.enumeratedValues = _values;
            this.exaustive = _exaustive;
        }
    }
}

