/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.openapi.Disposable;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XDebugViewBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XStackFrameNode;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class XVariablesView
extends XDebugViewBase {
    private final XDebuggerTreePanel myDebuggerTreePanel;
    private XDebuggerTreeState myTreeState;
    private Object myFrameEqualityObject;
    private XDebuggerTreeRestorer myTreeRestorer;

    public XVariablesView(@NotNull XDebugSession session, Disposable parentDisposable) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/frame/XVariablesView.<init> must not be null");
        }
        super(session, parentDisposable);
        XDebuggerEditorsProvider editorsProvider = session.getDebugProcess().getEditorsProvider();
        this.myDebuggerTreePanel = new XDebuggerTreePanel(session, editorsProvider, null, "XDebugger.Variables.Tree.Popup");
        DnDManager.getInstance().registerSource((DnDSource)this.myDebuggerTreePanel, (JComponent)((Object)this.myDebuggerTreePanel.getTree()));
    }

    @Override
    protected void rebuildView(XDebugViewBase.SessionEvent event) {
        XStackFrame stackFrame = this.mySession.getCurrentStackFrame();
        XDebuggerTree tree = this.myDebuggerTreePanel.getTree();
        if (event == XDebugViewBase.SessionEvent.BEFORE_RESUME || event == XDebugViewBase.SessionEvent.SETTINGS_CHANGED) {
            if (this.myTreeRestorer != null) {
                this.myTreeRestorer.dispose();
            }
            this.myFrameEqualityObject = stackFrame != null ? stackFrame.getEqualityObject() : null;
            this.myTreeState = XDebuggerTreeState.saveState(tree);
            if (event == XDebugViewBase.SessionEvent.BEFORE_RESUME) {
                return;
            }
        }
        tree.markNodesObsolete();
        if (stackFrame != null) {
            tree.setSourcePosition(stackFrame.getSourcePosition());
            tree.setRoot(new XStackFrameNode(tree, stackFrame), false);
            Object newEqualityObject = stackFrame.getEqualityObject();
            if (this.myFrameEqualityObject != null && newEqualityObject != null && this.myFrameEqualityObject.equals(newEqualityObject) && this.myTreeState != null) {
                this.myTreeRestorer = this.myTreeState.restoreState(tree);
            }
        } else {
            tree.setSourcePosition(null);
            tree.setRoot(MessageTreeNode.createInfoMessage(tree, null, this.mySession.getDebugProcess().getCurrentStateMessage()), true);
        }
    }

    public JComponent getPanel() {
        return this.myDebuggerTreePanel.getMainPanel();
    }

    @Override
    public void dispose() {
        DnDManager.getInstance().unregisterSource((DnDSource)this.myDebuggerTreePanel, (JComponent)((Object)this.myDebuggerTreePanel.getTree()));
        super.dispose();
    }
}

