/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public abstract class AbstractValueHintTreeComponent<H> {
    private static final Icon ICON_FWD = IconLoader.getIcon((String)"/actions/forward.png");
    private static final Icon ICON_BACK = IconLoader.getIcon((String)"/actions/back.png");
    private static final Icon ICON_UNMARK_WEBROOT = IconLoader.getIcon((String)"/modules/unmarkWebroot.png");
    private static final int HISTORY_SIZE = 11;
    private final ArrayList<H> myHistory = new ArrayList();
    private int myCurrentIndex = -1;
    private final AbstractValueHint myValueHint;
    private final Tree myTree;
    private JPanel myMainPanel;

    protected AbstractValueHintTreeComponent(AbstractValueHint valueHint, Tree tree, H initialItem) {
        this.myValueHint = valueHint;
        this.myTree = tree;
        this.myHistory.add(initialItem);
    }

    public JPanel getMainPanel() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JPanel(new BorderLayout());
            this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myTree), "Center");
            this.myMainPanel.add((Component)this.createToolbar(this.myMainPanel), "North");
        }
        return this.myMainPanel;
    }

    private AnAction createGoForwardAction() {
        return new AnAction(CodeInsightBundle.message((String)"quick.definition.forward", (Object[])new Object[0]), null, ICON_FWD){

            public void actionPerformed(AnActionEvent e) {
                if (AbstractValueHintTreeComponent.this.myHistory.size() > 1 && AbstractValueHintTreeComponent.this.myCurrentIndex < AbstractValueHintTreeComponent.this.myHistory.size() - 1) {
                    AbstractValueHintTreeComponent.this.myCurrentIndex++;
                    AbstractValueHintTreeComponent.this.updateHint();
                }
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(AbstractValueHintTreeComponent.this.myHistory.size() > 1 && AbstractValueHintTreeComponent.this.myCurrentIndex < AbstractValueHintTreeComponent.this.myHistory.size() - 1);
            }
        };
    }

    private void updateHint() {
        this.myValueHint.shiftLocation();
        this.updateTree(this.myHistory.get(this.myCurrentIndex));
    }

    private AnAction createGoBackAction() {
        return new AnAction(CodeInsightBundle.message((String)"quick.definition.back", (Object[])new Object[0]), null, ICON_BACK){

            public void actionPerformed(AnActionEvent e) {
                if (AbstractValueHintTreeComponent.this.myHistory.size() > 1 && AbstractValueHintTreeComponent.this.myCurrentIndex > 0) {
                    AbstractValueHintTreeComponent.this.myCurrentIndex--;
                    AbstractValueHintTreeComponent.this.updateHint();
                }
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(AbstractValueHintTreeComponent.this.myHistory.size() > 1 && AbstractValueHintTreeComponent.this.myCurrentIndex > 0);
            }
        };
    }

    protected abstract void updateTree(H var1);

    protected void addToHistory(H item) {
        if (this.myCurrentIndex < 11) {
            this.myCurrentIndex = this.myCurrentIndex != -1 ? ++this.myCurrentIndex : 1;
            this.myHistory.add(this.myCurrentIndex, item);
        }
    }

    private JComponent createToolbar(JPanel parent) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(this.createSetRoot());
        AnAction back = this.createGoBackAction();
        back.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(37, 8)), (JComponent)parent);
        group.add(back);
        AnAction forward = this.createGoForwardAction();
        forward.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(39, 8)), (JComponent)parent);
        group.add(forward);
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
    }

    private AnAction createSetRoot() {
        String title = XDebuggerBundle.message((String)"xdebugger.popup.value.tree.set.root.action.tooltip", (Object[])new Object[0]);
        return new AnAction(title, title, ICON_UNMARK_WEBROOT){

            public void actionPerformed(AnActionEvent e) {
                TreePath path = AbstractValueHintTreeComponent.this.myTree.getSelectionPath();
                if (path == null) {
                    return;
                }
                Object node = path.getLastPathComponent();
                AbstractValueHintTreeComponent.this.setNodeAsRoot(node);
            }
        };
    }

    protected abstract void setNodeAsRoot(Object var1);
}

