/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHintTreeComponent;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractValueHint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint");
    @NonNls
    private static final String DIMENSION_SERVICE_KEY = "DebuggerActiveHint";
    private static final Icon COLLAPSED_TREE_ICON = IconLoader.getIcon((String)"/general/add.png");
    private static final int HINT_TIMEOUT = 7000;
    private final KeyListener myEditorKeyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (!AbstractValueHint.isAltMask(e.getModifiers())) {
                ValueLookupManager.getInstance(AbstractValueHint.this.myProject).hideHint();
            }
        }
    };
    private static final TextAttributes ourReferenceAttributes = new TextAttributes();
    private RangeHighlighter myHighlighter;
    private Cursor myStoredCursor;
    private final Project myProject;
    private final Editor myEditor;
    private final ValueHintType myType;
    private Point myPoint;
    private LightweightHint myCurrentHint;
    private JBPopup myPopup;
    private boolean myHintHidden;
    private TextRange myCurrentRange;

    public AbstractValueHint(Project project, Editor editor, Point point, ValueHintType type, TextRange textRange) {
        this.myPoint = point;
        this.myProject = project;
        this.myEditor = editor;
        this.myType = type;
        this.myCurrentRange = textRange;
    }

    protected abstract boolean canShowHint();

    protected abstract void evaluateAndShowHint();

    private void resize(TreePath path, JTree tree) {
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            return;
        }
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        if (popupWindow == null) {
            return;
        }
        Dimension size = tree.getPreferredSize();
        Point location = popupWindow.getLocation();
        Rectangle windowBounds = popupWindow.getBounds();
        Rectangle bounds = tree.getPathBounds(path);
        if (bounds == null) {
            return;
        }
        Rectangle targetBounds = new Rectangle(location.x, location.y, Math.max(Math.max(size.width, bounds.width) + 20, windowBounds.width), Math.max(tree.getRowCount() * bounds.height + 55, windowBounds.height));
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        popupWindow.setBounds(targetBounds);
        popupWindow.validate();
        popupWindow.repaint();
    }

    private void updateInitialBounds(Tree tree) {
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        Dimension size = tree.getPreferredSize();
        Point location = popupWindow.getLocation();
        Rectangle windowBounds = popupWindow.getBounds();
        Rectangle targetBounds = new Rectangle(location.x, location.y, Math.max(size.width + 250, windowBounds.width), Math.max(size.height, windowBounds.height));
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        popupWindow.setBounds(targetBounds);
        popupWindow.validate();
        popupWindow.repaint();
    }

    public boolean isKeepHint(Editor editor, Point point) {
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            return false;
        }
        if (this.myType == ValueHintType.MOUSE_CLICK_HINT) {
            if (this.myCurrentHint != null && this.myCurrentHint.isVisible()) {
                return true;
            }
        } else {
            int offset = AbstractValueHint.calculateOffset(editor, point);
            if (this.myCurrentRange != null && this.myCurrentRange.getStartOffset() <= offset && offset <= this.myCurrentRange.getEndOffset()) {
                return true;
            }
        }
        return false;
    }

    public static int calculateOffset(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint.calculateOffset must not be null");
        }
        if (point == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint.calculateOffset must not be null");
        }
        LogicalPosition pos = editor.xyToLogicalPosition(point);
        return editor.logicalPositionToOffset(pos);
    }

    public void hideHint() {
        this.myHintHidden = true;
        this.myCurrentRange = null;
        if (this.myStoredCursor != null) {
            JComponent internalComponent = this.myEditor.getContentComponent();
            internalComponent.setCursor(this.myStoredCursor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("internalComponent.setCursor(myStoredCursor)");
            }
            internalComponent.removeKeyListener(this.myEditorKeyListener);
        }
        if (this.myCurrentHint != null) {
            this.myCurrentHint.hide();
            this.myCurrentHint = null;
        }
        if (this.myHighlighter != null) {
            this.myEditor.getMarkupModel().removeHighlighter(this.myHighlighter);
            this.myHighlighter = null;
        }
    }

    public void invokeHint() {
        if (!this.canShowHint()) {
            this.hideHint();
            return;
        }
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            this.myHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(this.myCurrentRange.getStartOffset(), this.myCurrentRange.getEndOffset(), 6001, ourReferenceAttributes, HighlighterTargetArea.EXACT_RANGE);
            JComponent internalComponent = this.myEditor.getContentComponent();
            this.myStoredCursor = internalComponent.getCursor();
            internalComponent.addKeyListener(this.myEditorKeyListener);
            internalComponent.setCursor(AbstractValueHint.hintCursor());
            if (LOG.isDebugEnabled()) {
                LOG.debug("internalComponent.setCursor(hintCursor())");
            }
        } else {
            this.evaluateAndShowHint();
        }
    }

    private static Cursor hintCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public void shiftLocation() {
        Window window;
        if (this.myPopup != null && (window = SwingUtilities.getWindowAncestor(this.myPopup.getContent())) != null) {
            this.myPoint = new RelativePoint((Component)window, new Point(2, 2)).getPoint((Component)this.myEditor.getContentComponent());
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    protected ValueHintType getType() {
        return this.myType;
    }

    public void showTreePopup(AbstractValueHintTreeComponent<?> component, Tree tree, String title) {
        if (this.myPopup != null) {
            this.myPopup.cancel();
        }
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component.getMainPanel(), (JComponent)tree).setRequestFocus(true).setTitle(title).setResizable(true).setMovable(true).setDimensionServiceKey(this.getProject(), DIMENSION_SERVICE_KEY, false).createPopup();
        if (tree instanceof Disposable) {
            Disposer.register((Disposable)this.myPopup, (Disposable)((Disposable)tree));
        }
        if (this.getEditor().getComponent().getRootPane() == null) {
            this.myPopup.cancel();
            return;
        }
        this.myPopup.show(new RelativePoint((Component)this.getEditor().getContentComponent(), this.myPoint));
        this.updateInitialBounds(tree);
    }

    protected boolean showHint(JComponent component) {
        this.myCurrentHint = new LightweightHint(component);
        if (this.getEditor().getComponent().getRootPane() == null) {
            return false;
        }
        Point p = HintManagerImpl.getHintPosition(this.myCurrentHint, this.getEditor(), this.getEditor().xyToLogicalPosition(this.myPoint), (short)2);
        HintManagerImpl.getInstanceImpl().showEditorHint(this.myCurrentHint, this.getEditor(), p, 42, 7000, false);
        return true;
    }

    protected boolean isHintHidden() {
        return this.myHintHidden;
    }

    protected JComponent createExpandableHintComponent(SimpleColoredText text, final Runnable expand) {
        JComponent component = HintUtil.createInformationLabel(text, COLLAPSED_TREE_ICON);
        AbstractValueHint.addMouseListenerToHierarchy(component, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AbstractValueHint.this.myCurrentHint != null) {
                    AbstractValueHint.this.myCurrentHint.hide();
                }
                expand.run();
            }
        });
        return component;
    }

    private static void addMouseListenerToHierarchy(Component c, MouseListener l) {
        c.addMouseListener(l);
        if (c instanceof Container) {
            Component[] children;
            Container container = (Container)c;
            for (Component child : children = container.getComponents()) {
                AbstractValueHint.addMouseListenerToHierarchy(child, l);
            }
        }
    }

    protected Point getPoint() {
        return this.myPoint;
    }

    protected TextRange getCurrentRange() {
        return this.myCurrentRange;
    }

    protected TreeModelListener createTreeListener(final Tree tree) {
        return new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                AbstractValueHint.this.resize(e.getTreePath(), (JTree)tree);
            }
        };
    }

    private static boolean isAltMask(int modifiers) {
        return modifiers == 8;
    }

    public static ValueHintType getType(EditorMouseEvent e) {
        return AbstractValueHint.isAltMask(e.getMouseEvent().getModifiers()) ? ValueHintType.MOUSE_ALT_OVER_HINT : ValueHintType.MOUSE_OVER_HINT;
    }

    static {
        ourReferenceAttributes.setForegroundColor(Color.blue);
        ourReferenceAttributes.setEffectColor(Color.blue);
        ourReferenceAttributes.setEffectType(EffectType.LINE_UNDERSCORE);
    }
}

