/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHintTreeComponent;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;

public class XValueHintTreeComponent
extends AbstractValueHintTreeComponent<Pair<XValue, String>> {
    private final XValueHint myValueHint;
    private final XDebuggerTree myTree;

    public XValueHintTreeComponent(XValueHint valueHint, XDebuggerTree tree, Pair<XValue, String> initialItem) {
        super(valueHint, tree, initialItem);
        this.myValueHint = valueHint;
        this.myTree = tree;
        this.updateTree(initialItem);
    }

    @Override
    protected void updateTree(Pair<XValue, String> selectedItem) {
        this.myTree.setRoot(new XValueNodeImpl(this.myTree, null, (XValue)selectedItem.getFirst()), true);
        this.myValueHint.showTreePopup(this, this.myTree, (String)selectedItem.getSecond());
    }

    @Override
    protected void setNodeAsRoot(Object node) {
        if (node instanceof XValueNodeImpl) {
            XValueNodeImpl valueNode = (XValueNodeImpl)node;
            this.myValueHint.shiftLocation();
            Pair item = Pair.create(valueNode.getValueContainer(), (Object)valueNode.getName());
            this.addToHistory(item);
            this.updateTree((Pair<XValue, String>)item);
        }
    }
}

