/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XQuickEvaluateHandler
extends QuickEvaluateHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.evaluate.quick.XQuickEvaluateHandler");

    @Override
    public boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler.isEnabled must not be null");
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session == null || !session.isSuspended()) {
            return false;
        }
        XStackFrame stackFrame = session.getCurrentStackFrame();
        return stackFrame != null && stackFrame.getEvaluator() != null;
    }

    @Override
    public AbstractValueHint createValueHint(final @NotNull Project project, final @NotNull Editor editor, final @NotNull Point point, final ValueHintType type) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler.createValueHint must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler.createValueHint must not be null");
        }
        if (point == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler.createValueHint must not be null");
        }
        final XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session == null) {
            return null;
        }
        XStackFrame stackFrame = session.getCurrentStackFrame();
        if (stackFrame == null) {
            return null;
        }
        final XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator == null) {
            return null;
        }
        return (AbstractValueHint)PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction((Computable)new Computable<XValueHint>(){

            public XValueHint compute() {
                int offset = AbstractValueHint.calculateOffset(editor, point);
                TextRange range = XQuickEvaluateHandler.getExpressionRange(evaluator, project, type, editor, offset);
                if (range == null) {
                    return null;
                }
                int textLength = editor.getDocument().getTextLength();
                if (range.getStartOffset() > range.getEndOffset() || range.getStartOffset() < 0 || range.getEndOffset() > textLength) {
                    LOG.error("invalid range: " + range + ", text length = " + textLength);
                    return null;
                }
                return new XValueHint(project, editor, point, type, range, evaluator, session);
            }
        });
    }

    @Nullable
    private static TextRange getExpressionRange(XDebuggerEvaluator evaluator, Project project, ValueHintType type, Editor editor, int offset) {
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        if ((type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT) && selectionModel.hasSelection() && selectionStart <= offset && offset <= selectionEnd) {
            return new TextRange(selectionStart, selectionEnd);
        }
        return evaluator.getExpressionRangeAtOffset(project, editor.getDocument(), offset);
    }

    @Override
    public boolean canShowHint(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/quick/XQuickEvaluateHandler.canShowHint must not be null");
        }
        return this.isEnabled(project);
    }

    @Override
    public int getValueLookupDelay(Project project) {
        XDebuggerEvaluator evaluator;
        XStackFrame stackFrame;
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session != null && (stackFrame = session.getCurrentStackFrame()) != null && (evaluator = stackFrame.getEvaluator()) != null) {
            return evaluator.getValuePopupDelay();
        }
        return 700;
    }
}

