/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.ClassArrayConverter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassArrayConverterImpl
extends ClassArrayConverter {
    private static final UserDataCache<JavaClassReferenceProvider, Project, Object> REFERENCE_PROVIDER = new UserDataCache<JavaClassReferenceProvider, Project, Object>("ClassArrayConverterImpl"){

        protected JavaClassReferenceProvider compute(Project project, Object p) {
            JavaClassReferenceProvider provider = new JavaClassReferenceProvider(project);
            provider.setSoft(true);
            provider.setAllowEmpty(true);
            return provider;
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray;
        String s = genericDomValue.getStringValue();
        if (s == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/ClassArrayConverterImpl.createReferences must not return null");
            return psiReferenceArray;
        } else {
            int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
            ArrayList<PsiReference> list = new ArrayList<PsiReference>();
            int pos = -1;
            while (true) {
                if (pos + 1 < s.length() && Character.isWhitespace(s.charAt(pos + 1))) {
                    ++pos;
                    continue;
                }
                int nextPos = s.indexOf(44, pos + 1);
                if (nextPos == -1) {
                    ClassArrayConverterImpl.createReference(element, s.substring(pos + 1), pos + 1 + offset, list);
                    psiReferenceArray = list.toArray(new PsiReference[list.size()]);
                    if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/converters/ClassArrayConverterImpl.createReferences must not return null");
                    return psiReferenceArray;
                }
                ClassArrayConverterImpl.createReference(element, s.substring(pos + 1, nextPos), pos + 1 + offset, list);
                pos = nextPos;
            }
        }
    }

    private static void createReference(PsiElement element, String s, int offset, List<PsiReference> list) {
        PsiReference[] references;
        for (PsiReference ref : references = ((JavaClassReferenceProvider)REFERENCE_PROVIDER.get((UserDataHolder)element.getProject(), null)).getReferencesByString(s, element, offset)) {
            list.add(ref);
        }
    }
}

