/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.tree.AbstractFileTreeTable;
import com.intellij.util.ui.tree.LanguagePerFileConfigurable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguagePerFileConfigurable<T>
implements SearchableConfigurable {
    protected final Project myProject;
    private final Class<T> myValueClass;
    private final PerFileMappings<T> myMappings;
    private final String myTreeTableTitle;
    private final String myOverrideQuestion;
    private final String myOverrideTitle;
    private final AbstractFileTreeTable<T> myTreeView;
    private JScrollPane myTreePanel;
    private JPanel myPanel;
    private JLabel myLabel;

    protected LanguagePerFileConfigurable(Project project, Class<T> valueClass, PerFileMappings<T> mappings, String caption, String treeTableTitle, String overrideQuestion, String overrideTitle) {
        this.myProject = project;
        this.myValueClass = valueClass;
        this.myMappings = mappings;
        this.myTreeTableTitle = treeTableTitle;
        this.myOverrideQuestion = overrideQuestion;
        this.myOverrideTitle = overrideTitle;
        this.$$$setupUI$$$();
        this.myLabel.setText(caption);
        this.myTreeView = new MyTreeTable();
    }

    public JComponent createComponent() {
        this.myTreePanel.setViewportView((Component)((Object)this.myTreeView));
        return this.myPanel;
    }

    public boolean isModified() {
        Map<VirtualFile, T> mapping = this.myMappings.getMappings();
        boolean same = ((Object)this.myTreeView.getValues()).equals(mapping);
        return !same;
    }

    public void apply() throws ConfigurationException {
        this.myMappings.setMappings(this.myTreeView.getValues());
    }

    public void reset() {
        this.myTreeView.reset(this.myMappings.getMappings());
    }

    public void disposeUIResources() {
    }

    public void selectFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ui/tree/LanguagePerFileConfigurable.selectFile must not be null");
        }
        this.myTreeView.select(virtualFile);
    }

    private void createUIComponents() {
        this.myTreePanel = ScrollPaneFactory.createScrollPane((JComponent)new JTable());
    }

    protected abstract String visualize(@NotNull T var1);

    public AbstractFileTreeTable<T> getTreeView() {
        return this.myTreeView;
    }

    public String getId() {
        return this.getDisplayName();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    protected boolean handleDefaultValue(VirtualFile file, ColoredTableCellRenderer renderer) {
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
        this.myLabel = jLabel = new JLabel();
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = this.myTreePanel;
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private abstract class ChooseSomethingAction
    extends ComboBoxAction {
        private final VirtualFile myVirtualFile;

        public ChooseSomethingAction(VirtualFile virtualFile) {
            this.myVirtualFile = virtualFile;
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup defaultActionGroup = this.createGroup(true);
            if (defaultActionGroup == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ui/tree/LanguagePerFileConfigurable$ChooseSomethingAction.createPopupActionGroup must not return null");
            }
            return defaultActionGroup;
        }

        private com.intellij.util.ui.tree.LanguagePerFileConfigurable$ChooseSomethingAction.ChangeSomethingAction createChooseAction(VirtualFile virtualFile, T t) {
            return new ChangeSomethingAction(virtualFile, t){

                @Override
                protected void chosen(VirtualFile file, T t) {
                    ChooseSomethingAction.this.chosen(file, t);
                }
            };
        }

        protected abstract void chosen(VirtualFile var1, T var2);

        public DefaultActionGroup createGroup(boolean showClear) {
            DefaultActionGroup group = new DefaultActionGroup();
            if (showClear) {
                group.add((AnAction)this.createChooseAction(this.myVirtualFile, null));
            }
            ArrayList values = new ArrayList(LanguagePerFileConfigurable.this.myMappings.getAvailableValues(this.myVirtualFile));
            Collections.sort(values, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return LanguagePerFileConfigurable.this.visualize(o1).compareTo(LanguagePerFileConfigurable.this.visualize(o2));
                }
            });
            for (Object t : values) {
                group.add((AnAction)this.createChooseAction(this.myVirtualFile, t));
            }
            return group;
        }

        private abstract class ChangeSomethingAction
        extends AnAction {
            private final VirtualFile myFile;
            private final T myDialect;

            ChangeSomethingAction(@Nullable VirtualFile file, T t) {
                super("", "", null);
                this.getTemplatePresentation().setText(t == null ? "Clear" : LanguagePerFileConfigurable.this.visualize(t));
                this.myFile = file;
                this.myDialect = t;
            }

            public void actionPerformed(AnActionEvent e) {
                this.chosen(this.myFile, this.myDialect);
            }

            protected abstract void chosen(VirtualFile var1, T var2);
        }
    }

    private class MyTreeTable
    extends AbstractFileTreeTable<T> {
        public MyTreeTable() {
            super(LanguagePerFileConfigurable.this.myProject, LanguagePerFileConfigurable.this.myValueClass, LanguagePerFileConfigurable.this.myTreeTableTitle);
            this.getValueColumn().setCellEditor(new DefaultCellEditor(new JComboBox()){
                private VirtualFile myVirtualFile;
                {
                    super(x0);
                    this.delegate = new DefaultCellEditor.EditorDelegate(){

                        @Override
                        public void setValue(Object value) {
                            MyTreeTable.this.getTableModel().setValueAt(value, (Object)new DefaultMutableTreeNode(myVirtualFile), -1);
                        }

                        @Override
                        public Object getCellEditorValue() {
                            return MyTreeTable.this.getTableModel().getValueAt((Object)new DefaultMutableTreeNode(myVirtualFile), 1);
                        }
                    };
                }

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    Object o = table.getModel().getValueAt(row, 0);
                    this.myVirtualFile = o instanceof Project ? null : (VirtualFile)o;
                    ChooseSomethingAction changeAction = new ChooseSomethingAction(this.myVirtualFile){

                        public void update(AnActionEvent e) {
                            boolean enabled = MyTreeTable.this.isValueEditableForFile(myVirtualFile);
                            if (myVirtualFile != null) {
                                Object mapping = LanguagePerFileConfigurable.this.myMappings.getMapping(myVirtualFile);
                                e.getPresentation().setText(mapping == null ? "" : LanguagePerFileConfigurable.this.visualize(mapping));
                            }
                            e.getPresentation().setEnabled(enabled);
                        }

                        @Override
                        protected void chosen(VirtualFile virtualFile, T charset) {
                            MyTreeTable.this.getValueColumn().getCellEditor().stopCellEditing();
                            if (MyTreeTable.this.clearSubdirectoriesOnDemandOrCancel(virtualFile, LanguagePerFileConfigurable.this.myOverrideQuestion, LanguagePerFileConfigurable.this.myOverrideTitle)) {
                                MyTreeTable.this.getTableModel().setValueAt(charset, (Object)new DefaultMutableTreeNode(virtualFile), 1);
                            }
                        }
                    };
                    Presentation templatePresentation = changeAction.getTemplatePresentation();
                    JComponent comboComponent = changeAction.createCustomComponent(templatePresentation);
                    DataContext dataContext = SimpleDataContext.getSimpleContext(PlatformDataKeys.VIRTUAL_FILE.getName(), this.myVirtualFile, SimpleDataContext.getProjectContext(MyTreeTable.this.getProject()));
                    AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", templatePresentation, ActionManager.getInstance(), 0);
                    changeAction.update(event);
                    this.editorComponent = comboComponent;
                    comboComponent.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentShown(ComponentEvent e) {
                            AbstractFileTreeTable.press((Container)e.getComponent());
                        }
                    });
                    Object t = MyTreeTable.this.getTableModel().getValueAt((Object)new DefaultMutableTreeNode(this.myVirtualFile), 1);
                    templatePresentation.setText(t == null ? "" : LanguagePerFileConfigurable.this.visualize(t));
                    comboComponent.revalidate();
                    return this.editorComponent;
                }
            });
            this.getValueColumn().setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    Object t = value;
                    if (t != null) {
                        this.append(LanguagePerFileConfigurable.this.visualize(t), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        VirtualFile file;
                        Object userObject = table.getModel().getValueAt(row, 0);
                        VirtualFile virtualFile = file = userObject instanceof VirtualFile ? (VirtualFile)userObject : null;
                        if (file != null) {
                            if (LanguagePerFileConfigurable.this.handleDefaultValue(file, this)) {
                                return;
                            }
                            if (!MyTreeTable.this.isValueEditableForFile(file)) {
                                this.append("N/A", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                            }
                        }
                    }
                }
            });
        }

        @Override
        protected boolean isValueEditableForFile(VirtualFile virtualFile) {
            FileType fileType;
            boolean enabled = true;
            if (virtualFile != null && !virtualFile.isDirectory() && (fileType = virtualFile.getFileType()).isBinary()) {
                enabled = false;
            }
            return enabled;
        }
    }
}

