/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.ChangeTrackingValueContainer;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableValueContainer;
import com.intellij.util.indexing.ValueContainer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class MemoryIndexStorage<Key, Value>
implements IndexStorage<Key, Value> {
    private final Map<Key, UpdatableValueContainer<Value>> myMap = new HashMap<Key, UpdatableValueContainer<Value>>();
    private final IndexStorage<Key, Value> myBackendStorage;
    private final List<BufferingStateListener> myListeners = ContainerUtil.createEmptyCOWList();
    private final AtomicBoolean myBufferingEnabled = new AtomicBoolean(false);

    public MemoryIndexStorage(IndexStorage<Key, Value> backend) {
        this.myBackendStorage = backend;
    }

    public IndexStorage<Key, Value> getBackendStorage() {
        return this.myBackendStorage;
    }

    public void addBufferingStateListsner(BufferingStateListener listener) {
        this.myListeners.add(listener);
    }

    public void removeBufferingStateListsner(BufferingStateListener listener) {
        this.myListeners.remove(listener);
    }

    public void setBufferingEnabled(boolean enabled) {
        boolean wasEnabled = this.myBufferingEnabled.getAndSet(enabled);
        if (wasEnabled != enabled) {
            for (BufferingStateListener listener : this.myListeners) {
                listener.bufferingStateChanged(enabled);
            }
        }
    }

    public boolean isBufferingEnabled() {
        return this.myBufferingEnabled.get();
    }

    public void clearMemoryMap() {
        this.myMap.clear();
    }

    public void fireMemoryStorageCleared() {
        for (BufferingStateListener listener : this.myListeners) {
            listener.memoryStorageCleared();
        }
    }

    @Override
    public void close() throws StorageException {
        this.myBackendStorage.close();
    }

    @Override
    public void clear() throws StorageException {
        this.clearMemoryMap();
        this.myBackendStorage.clear();
    }

    @Override
    public void flush() throws IOException {
        this.myBackendStorage.flush();
    }

    @Override
    public Collection<Key> getKeys() throws StorageException {
        HashSet keys = new HashSet();
        this.processKeys((Processor<Key>)new CommonProcessors.CollectProcessor(keys));
        return keys;
    }

    @Override
    public boolean processKeys(final Processor<Key> processor) throws StorageException {
        final HashSet<Key> stopList = new HashSet<Key>();
        Processor decoratingProcessor = new Processor<Key>(){

            public boolean process(Key key) {
                if (stopList.contains(key)) {
                    return true;
                }
                UpdatableValueContainer container = (UpdatableValueContainer)MemoryIndexStorage.this.myMap.get(key);
                if (container != null && container.size() == 0) {
                    return true;
                }
                return processor.process(key);
            }
        };
        for (Key key : this.myMap.keySet()) {
            if (!decoratingProcessor.process(key)) {
                return false;
            }
            stopList.add(key);
        }
        return this.myBackendStorage.processKeys(decoratingProcessor);
    }

    @Override
    public void addValue(Key key, int inputId, Value value) throws StorageException {
        if (this.myBufferingEnabled.get()) {
            this.getMemValueContainer(key).addValue(inputId, value);
            return;
        }
        UpdatableValueContainer<Value> valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            valueContainer.addValue(inputId, value);
        }
        this.myBackendStorage.addValue(key, inputId, value);
    }

    @Override
    public void removeValue(Key key, int inputId, Value value) throws StorageException {
        if (this.myBufferingEnabled.get()) {
            this.getMemValueContainer(key).removeValue(inputId, value);
            return;
        }
        UpdatableValueContainer<Value> valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            valueContainer.removeValue(inputId, value);
        }
        this.myBackendStorage.removeValue(key, inputId, value);
    }

    @Override
    public void removeAllValues(Key key, int inputId) throws StorageException {
        if (this.myBufferingEnabled.get()) {
            this.getMemValueContainer(key).removeAllValues(inputId);
            return;
        }
        UpdatableValueContainer<Value> valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            valueContainer.removeAllValues(inputId);
        }
        this.myBackendStorage.removeAllValues(key, inputId);
    }

    private UpdatableValueContainer<Value> getMemValueContainer(final Key key) {
        UpdatableValueContainer<Value> valueContainer = this.myMap.get(key);
        if (valueContainer == null) {
            valueContainer = new ChangeTrackingValueContainer(new ChangeTrackingValueContainer.Initializer<Value>(){

                @Override
                public Object getLock() {
                    return this;
                }

                public ValueContainer<Value> compute() {
                    try {
                        return MemoryIndexStorage.this.myBackendStorage.read(key);
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.myMap.put(key, valueContainer);
        }
        return valueContainer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ValueContainer<Value> read(Key key) throws StorageException {
        ValueContainer<Value> valueContainer;
        ValueContainer<Value> valueContainer2 = (ValueContainer<Value>)this.myMap.get(key);
        if (valueContainer2 != null) {
            valueContainer = valueContainer2;
            if (valueContainer == null) throw new IllegalStateException("@NotNull method com/intellij/util/indexing/MemoryIndexStorage.read must not return null");
            return valueContainer;
        }
        valueContainer = this.myBackendStorage.read(key);
        if (valueContainer != null) return valueContainer;
        throw new IllegalStateException("@NotNull method com/intellij/util/indexing/MemoryIndexStorage.read must not return null");
    }

    public static interface BufferingStateListener {
        public void bufferingStateChanged(boolean var1);

        public void memoryStorageCleared();
    }
}

